/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.key.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.key.Gs2KeyRestClient;
import io.gs2.key.domain.model.KeyDomain;
import io.gs2.key.domain.model.NamespaceDomain;
import io.gs2.key.model.Key;
import io.gs2.key.request.DescribeKeysRequest;
import io.gs2.key.result.DescribeKeysResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeKeysIterator
implements Iterator<Key>,
Iterable<Key> {
    CacheDatabase cache;
    Gs2KeyRestClient client;
    String namespaceName;
    String pageToken;
    boolean last;
    List<Key> result;
    Integer fetchSize;

    public DescribeKeysIterator(CacheDatabase cache, Gs2KeyRestClient client, String namespaceName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<Key>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "Key");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, Key.class)) {
            this.result = this.cache.list(parentKey, Key.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeKeysResult r = this.client.describeKeys(new DescribeKeysRequest().withNamespaceName(this.namespaceName).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (Key item : this.result) {
                this.cache.put(parentKey, KeyDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, Key.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public Key next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        Key ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<Key> iterator() {
        return this;
    }
}

