/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.jobQueue.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.jobQueue.Gs2JobQueueRestClient;
import io.gs2.jobQueue.domain.iterator.DescribeDeadLetterJobsByUserIdIterator;
import io.gs2.jobQueue.domain.iterator.DescribeJobsByUserIdIterator;
import io.gs2.jobQueue.domain.model.DeadLetterJobDomain;
import io.gs2.jobQueue.domain.model.JobDomain;
import io.gs2.jobQueue.domain.model.NamespaceDomain;
import io.gs2.jobQueue.model.Job;
import io.gs2.jobQueue.request.PushByUserIdRequest;
import io.gs2.jobQueue.request.RunByUserIdRequest;
import io.gs2.jobQueue.result.PushByUserIdResult;
import io.gs2.jobQueue.result.RunByUserIdResult;

public class UserDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2JobQueueRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String parentKey;
    Boolean isLastJob;
    String nextPageToken;

    public Boolean getIsLastJob() {
        return this.isLastJob;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public UserDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2JobQueueRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "User");
    }

    public JobDomain[] push(PushByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId);
        PushByUserIdResult result = this.client.pushByUserId(request);
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Job");
        for (Job item : result.getItems()) {
            if (item == null) continue;
            this.cache.put(parentKey, JobDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        JobDomain[] domain = new JobDomain[result.getItems().size()];
        for (int i = 0; i < result.getItems().size(); ++i) {
            domain[i] = new JobDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), result.getItems().get(i).getUserId(), result.getItems().get(i).getName());
        }
        this.jobQueueDomain.push(this.namespaceName);
        return domain;
    }

    public JobDomain run(RunByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId);
        RunByUserIdResult result = null;
        try {
            result = this.client.runByUserId(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Job");
        this.cache.delete(parentKey, JobDomain.createCacheKey(result.getItem().getName() != null ? result.getItem().getName().toString() : null), Job.class);
        if (result.getItem() != null) {
            Gs2.updateCacheFromJobResult(this.cache, result.getItem(), result.getResult());
        }
        JobDomain domain = new JobDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), result.getItem().getUserId(), result.getItem().getName());
        domain.isLastJob = result.getIsLastJob();
        return domain;
    }

    public DescribeJobsByUserIdIterator jobs() {
        return new DescribeJobsByUserIdIterator(this.cache, this.client, this.namespaceName, this.userId);
    }

    public JobDomain job(String jobName) {
        return new JobDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.userId, jobName);
    }

    public DescribeDeadLetterJobsByUserIdIterator deadLetterJobs() {
        return new DescribeDeadLetterJobsByUserIdIterator(this.cache, this.client, this.namespaceName, this.userId);
    }

    public DeadLetterJobDomain deadLetterJob(String deadLetterJobName) {
        return new DeadLetterJobDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.userId, deadLetterJobName);
    }

    public static String createCacheParentKey(String namespaceName, String userId, String childType) {
        return String.join((CharSequence)":", "jobQueue", namespaceName, userId, childType);
    }

    public static String createCacheKey(String userId) {
        return String.join((CharSequence)":", userId);
    }
}

