/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.jobQueue.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.jobQueue.Gs2JobQueueRestClient;
import io.gs2.jobQueue.domain.model.JobResultDomain;
import io.gs2.jobQueue.domain.model.UserDomain;
import io.gs2.jobQueue.model.Job;
import io.gs2.jobQueue.request.DeleteJobByUserIdRequest;
import io.gs2.jobQueue.request.GetJobByUserIdRequest;
import io.gs2.jobQueue.result.DeleteJobByUserIdResult;
import io.gs2.jobQueue.result.GetJobByUserIdResult;

public class JobDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2JobQueueRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String jobName;
    private final String parentKey;
    Boolean isLastJob;

    public Boolean getIsLastJob() {
        return this.isLastJob;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getJobName() {
        return this.jobName;
    }

    public JobDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId, String jobName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2JobQueueRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.jobName = jobName;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Job");
    }

    private Job get(GetJobByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withJobName(this.jobName);
        GetJobByUserIdResult result = this.client.getJobByUserId(request);
        return result.getItem();
    }

    public JobDomain delete(DeleteJobByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withJobName(this.jobName);
        DeleteJobByUserIdResult result = null;
        try {
            result = this.client.deleteJobByUserId(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, JobDomain.createCacheKey(request.getJobName() != null ? request.getJobName().toString() : null), Job.class);
        JobDomain domain = this;
        return domain;
    }

    public JobResultDomain jobResult(String tryNumber) {
        return new JobResultDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.userId, this.jobName, tryNumber);
    }

    public static String createCacheParentKey(String namespaceName, String userId, String jobName, String childType) {
        return String.join((CharSequence)":", "jobQueue", namespaceName, userId, jobName, childType);
    }

    public static String createCacheKey(String jobName) {
        return String.join((CharSequence)":", jobName);
    }

    public Job model() {
        Job value = this.cache.get(this.parentKey, JobDomain.createCacheKey(this.getJobName() != null ? this.getJobName().toString() : null), Job.class);
        if (value == null) {
            try {
                this.get(new GetJobByUserIdRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, JobDomain.createCacheKey(this.getJobName() != null ? this.getJobName().toString() : null), Job.class);
            }
            value = this.cache.get(this.parentKey, JobDomain.createCacheKey(this.getJobName() != null ? this.getJobName().toString() : null), Job.class);
        }
        return value;
    }
}

