/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.inventory.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.inventory.Gs2InventoryRestClient;
import io.gs2.inventory.domain.iterator.DescribeReferenceOfByUserIdIterator;
import io.gs2.inventory.domain.model.InventoryDomain;
import io.gs2.inventory.domain.model.ItemModelDomain;
import io.gs2.inventory.domain.model.ReferenceOfDomain;
import io.gs2.inventory.model.ItemSet;
import io.gs2.inventory.request.AcquireItemSetByUserIdRequest;
import io.gs2.inventory.request.AddReferenceOfByUserIdRequest;
import io.gs2.inventory.request.ConsumeItemSetByUserIdRequest;
import io.gs2.inventory.request.DeleteItemSetByUserIdRequest;
import io.gs2.inventory.request.GetItemSetByUserIdRequest;
import io.gs2.inventory.request.GetItemWithSignatureByUserIdRequest;
import io.gs2.inventory.result.AcquireItemSetByUserIdResult;
import io.gs2.inventory.result.AddReferenceOfByUserIdResult;
import io.gs2.inventory.result.ConsumeItemSetByUserIdResult;
import io.gs2.inventory.result.DeleteItemSetByUserIdResult;
import io.gs2.inventory.result.GetItemSetByUserIdResult;
import io.gs2.inventory.result.GetItemWithSignatureByUserIdResult;
import java.util.List;

public class ItemSetDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2InventoryRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String inventoryName;
    private final String itemName;
    private final String itemSetName;
    private final String parentKey;
    String body;
    String signature;
    Long overflowCount;

    public String getBody() {
        return this.body;
    }

    public String getSignature() {
        return this.signature;
    }

    public Long getOverflowCount() {
        return this.overflowCount;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getInventoryName() {
        return this.inventoryName;
    }

    public String getItemName() {
        return this.itemName;
    }

    public String getItemSetName() {
        return this.itemSetName;
    }

    public ItemSetDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId, String inventoryName, String itemName, String itemSetName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2InventoryRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.inventoryName = inventoryName;
        this.itemName = itemName;
        this.itemSetName = itemSetName;
        this.parentKey = InventoryDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, this.inventoryName != null ? this.inventoryName.toString() : null, "ItemSet");
    }

    private List<ItemSet> get(GetItemSetByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withInventoryName(this.inventoryName).withItemName(this.itemName).withItemSetName(this.itemSetName);
        GetItemSetByUserIdResult result = this.client.getItemSetByUserId(request);
        String parentKey = InventoryDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, this.inventoryName != null ? this.inventoryName.toString() : null, "ItemSet");
        for (ItemSet item : result.getItems()) {
            if (item == null) continue;
            this.cache.put(parentKey, ItemSetDomain.createCacheKey(request.getItemName() != null ? request.getItemName().toString() : null, item.getName() != null ? item.getName().toString() : null), item, item.getExpiresAt() == null ? System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes : item.getExpiresAt());
            this.cache.put(parentKey, ItemSetDomain.createCacheKey(request.getItemName() != null ? request.getItemName().toString() : null, "null"), item, item.getExpiresAt() == null ? System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes : item.getExpiresAt());
        }
        if (result.getItemModel() != null) {
            this.cache.put(parentKey, ItemModelDomain.createCacheKey(request.getItemName() != null ? request.getItemName().toString() : null), result.getItemModel(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            this.cache.put(parentKey, ItemModelDomain.createCacheKey(request.getItemName() != null ? request.getItemName().toString() : null), result.getItemModel(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        if (result.getInventory() != null) {
            this.cache.put(parentKey, InventoryDomain.createCacheKey(request.getInventoryName() != null ? request.getInventoryName().toString() : null), result.getInventory(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            this.cache.put(parentKey, InventoryDomain.createCacheKey(request.getInventoryName() != null ? request.getInventoryName().toString() : null), result.getInventory(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItems();
    }

    public ItemSetDomain[] getItemWithSignature(GetItemWithSignatureByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withInventoryName(this.inventoryName).withItemName(this.itemName).withItemSetName(this.itemSetName);
        GetItemWithSignatureByUserIdResult result = this.client.getItemWithSignatureByUserId(request);
        String parentKey = InventoryDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, this.inventoryName != null ? this.inventoryName.toString() : null, "ItemSet");
        for (ItemSet item : result.getItems()) {
            if (item == null) continue;
            this.cache.put(parentKey, ItemSetDomain.createCacheKey(request.getItemName() != null ? request.getItemName().toString() : null, item.getName() != null ? item.getName().toString() : null), item, item.getExpiresAt() == null ? System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes : item.getExpiresAt());
            this.cache.put(parentKey, ItemSetDomain.createCacheKey(request.getItemName() != null ? request.getItemName().toString() : null, "null"), item, item.getExpiresAt() == null ? System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes : item.getExpiresAt());
        }
        if (result.getItemModel() != null) {
            this.cache.put(parentKey, ItemModelDomain.createCacheKey(request.getItemName() != null ? request.getItemName().toString() : null), result.getItemModel(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            this.cache.put(parentKey, ItemModelDomain.createCacheKey(request.getItemName() != null ? request.getItemName().toString() : null), result.getItemModel(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        if (result.getInventory() != null) {
            this.cache.put(parentKey, InventoryDomain.createCacheKey(request.getInventoryName() != null ? request.getInventoryName().toString() : null), result.getInventory(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            this.cache.put(parentKey, InventoryDomain.createCacheKey(request.getInventoryName() != null ? request.getInventoryName().toString() : null), result.getInventory(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        ItemSetDomain[] domain = new ItemSetDomain[result.getItems().size()];
        for (int i = 0; i < result.getItems().size(); ++i) {
            domain[i] = new ItemSetDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), result.getItems().get(i).getUserId(), result.getItems().get(i).getInventoryName(), result.getItems().get(i).getItemName(), result.getItems().get(i).getName());
        }
        this.body = result.getBody();
        this.signature = result.getSignature();
        return domain;
    }

    public ItemSetDomain[] acquire(AcquireItemSetByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withInventoryName(this.inventoryName).withItemName(this.itemName).withItemSetName(this.itemSetName);
        AcquireItemSetByUserIdResult result = this.client.acquireItemSetByUserId(request);
        String parentKey = InventoryDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, this.inventoryName != null ? this.inventoryName.toString() : null, "ItemSet");
        for (ItemSet item : result.getItems()) {
            if (item == null) continue;
            this.cache.put(parentKey, ItemSetDomain.createCacheKey(request.getItemName() != null ? request.getItemName().toString() : null, item.getName() != null ? item.getName().toString() : null), item, item.getExpiresAt() == null ? System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes : item.getExpiresAt());
            this.cache.put(parentKey, ItemSetDomain.createCacheKey(request.getItemName() != null ? request.getItemName().toString() : null, "null"), item, item.getExpiresAt() == null ? System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes : item.getExpiresAt());
        }
        if (result.getItemModel() != null) {
            this.cache.put(parentKey, ItemModelDomain.createCacheKey(request.getItemName() != null ? request.getItemName().toString() : null), result.getItemModel(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            this.cache.put(parentKey, ItemModelDomain.createCacheKey(request.getItemName() != null ? request.getItemName().toString() : null), result.getItemModel(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        if (result.getInventory() != null) {
            this.cache.put(parentKey, InventoryDomain.createCacheKey(request.getInventoryName() != null ? request.getInventoryName().toString() : null), result.getInventory(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            this.cache.put(parentKey, InventoryDomain.createCacheKey(request.getInventoryName() != null ? request.getInventoryName().toString() : null), result.getInventory(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        ItemSetDomain[] domain = new ItemSetDomain[result.getItems().size()];
        for (int i = 0; i < result.getItems().size(); ++i) {
            domain[i] = new ItemSetDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), result.getItems().get(i).getUserId(), result.getItems().get(i).getInventoryName(), result.getItems().get(i).getItemName(), result.getItems().get(i).getName());
        }
        this.overflowCount = result.getOverflowCount();
        return domain;
    }

    public ItemSetDomain[] consume(ConsumeItemSetByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withInventoryName(this.inventoryName).withItemName(this.itemName).withItemSetName(this.itemSetName);
        ConsumeItemSetByUserIdResult result = this.client.consumeItemSetByUserId(request);
        String parentKey = InventoryDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, this.inventoryName != null ? this.inventoryName.toString() : null, "ItemSet");
        for (ItemSet item : result.getItems()) {
            if (item == null) continue;
            this.cache.put(parentKey, ItemSetDomain.createCacheKey(request.getItemName() != null ? request.getItemName().toString() : null, item.getName() != null ? item.getName().toString() : null), item, item.getExpiresAt() == null ? System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes : item.getExpiresAt());
            this.cache.put(parentKey, ItemSetDomain.createCacheKey(request.getItemName() != null ? request.getItemName().toString() : null, "null"), item, item.getExpiresAt() == null ? System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes : item.getExpiresAt());
        }
        if (result.getItemModel() != null) {
            this.cache.put(parentKey, ItemModelDomain.createCacheKey(request.getItemName() != null ? request.getItemName().toString() : null), result.getItemModel(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            this.cache.put(parentKey, ItemModelDomain.createCacheKey(request.getItemName() != null ? request.getItemName().toString() : null), result.getItemModel(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        if (result.getInventory() != null) {
            this.cache.put(parentKey, InventoryDomain.createCacheKey(request.getInventoryName() != null ? request.getInventoryName().toString() : null), result.getInventory(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            this.cache.put(parentKey, InventoryDomain.createCacheKey(request.getInventoryName() != null ? request.getInventoryName().toString() : null), result.getInventory(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        ItemSetDomain[] domain = new ItemSetDomain[result.getItems().size()];
        for (int i = 0; i < result.getItems().size(); ++i) {
            domain[i] = new ItemSetDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), result.getItems().get(i).getUserId(), result.getItems().get(i).getInventoryName(), result.getItems().get(i).getItemName(), result.getItems().get(i).getName());
        }
        return domain;
    }

    public ItemSetDomain[] delete(DeleteItemSetByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withInventoryName(this.inventoryName).withItemName(this.itemName).withItemSetName(this.itemSetName);
        DeleteItemSetByUserIdResult result = null;
        try {
            result = this.client.deleteItemSetByUserId(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        String parentKey = InventoryDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, this.inventoryName != null ? this.inventoryName.toString() : null, "ItemSet");
        for (ItemSet item : this.cache.list(parentKey, ItemSet.class)) {
            this.cache.delete(parentKey, ItemSetDomain.createCacheKey(request.getItemName() != null ? request.getItemName().toString() : null, item.getName() != null ? item.getName().toString() : null), ItemSet.class);
        }
        ItemSetDomain[] domain = new ItemSetDomain[result.getItems().size()];
        for (int i = 0; i < result.getItems().size(); ++i) {
            domain[i] = new ItemSetDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), result.getItems().get(i).getUserId(), result.getItems().get(i).getInventoryName(), result.getItems().get(i).getItemName(), result.getItems().get(i).getName());
        }
        return domain;
    }

    public ReferenceOfDomain[] addReferenceOf(AddReferenceOfByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withInventoryName(this.inventoryName).withItemName(this.itemName).withItemSetName(this.itemSetName);
        AddReferenceOfByUserIdResult result = this.client.addReferenceOfByUserId(request);
        String parentKey = "inventory:String";
        for (String item : result.getItem()) {
            if (item == null) continue;
            this.cache.put(parentKey, item, item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            this.cache.put(parentKey, item, item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        if (result.getItemSet() != null) {
            this.cache.put(parentKey, ItemSetDomain.createCacheKey(request.getItemName() != null ? request.getItemName().toString() : null, result.getItemSet().getName() != null ? result.getItemSet().getName().toString() : null), result.getItemSet(), result.getItemSet().getExpiresAt() == null ? System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes : result.getItemSet().getExpiresAt());
            this.cache.put(parentKey, ItemSetDomain.createCacheKey(request.getItemName() != null ? request.getItemName().toString() : null, "null"), result.getItemSet(), result.getItemSet().getExpiresAt() == null ? System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes : result.getItemSet().getExpiresAt());
        }
        if (result.getItemModel() != null) {
            this.cache.put(parentKey, ItemModelDomain.createCacheKey(request.getItemName() != null ? request.getItemName().toString() : null), result.getItemModel(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            this.cache.put(parentKey, ItemModelDomain.createCacheKey(request.getItemName() != null ? request.getItemName().toString() : null), result.getItemModel(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        if (result.getInventory() != null) {
            this.cache.put(parentKey, InventoryDomain.createCacheKey(request.getInventoryName() != null ? request.getInventoryName().toString() : null), result.getInventory(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            this.cache.put(parentKey, InventoryDomain.createCacheKey(request.getInventoryName() != null ? request.getInventoryName().toString() : null), result.getInventory(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        ReferenceOfDomain[] domain = new ReferenceOfDomain[result.getItem().size()];
        for (int i = 0; i < result.getItem().size(); ++i) {
            domain[i] = new ReferenceOfDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), request.getUserId(), request.getInventoryName(), request.getItemName(), request.getItemSetName(), request.getReferenceOf());
        }
        return domain;
    }

    public DescribeReferenceOfByUserIdIterator referenceOves() {
        return new DescribeReferenceOfByUserIdIterator(this.cache, this.client, this.namespaceName, this.inventoryName, this.userId, this.itemName, this.itemSetName);
    }

    public ReferenceOfDomain referenceOf(String referenceOf) {
        return new ReferenceOfDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.userId, this.inventoryName, this.itemName, this.itemSetName, referenceOf);
    }

    public static String createCacheParentKey(String namespaceName, String userId, String inventoryName, String itemName, String itemSetName, String childType) {
        return String.join((CharSequence)":", "inventory", namespaceName, userId, inventoryName, itemName, itemSetName, childType);
    }

    public static String createCacheKey(String itemName, String itemSetName) {
        return String.join((CharSequence)":", itemName, itemSetName);
    }

    public ItemSet model() {
        ItemSet value = this.cache.get(this.parentKey, ItemSetDomain.createCacheKey(this.getItemName() != null ? this.getItemName().toString() : null, this.getItemSetName() != null ? this.getItemSetName().toString() : null), ItemSet.class);
        if (value == null) {
            try {
                this.get(new GetItemSetByUserIdRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, ItemSetDomain.createCacheKey(this.getItemName() != null ? this.getItemName().toString() : null, this.getItemSetName() != null ? this.getItemSetName().toString() : null), ItemSet.class);
            }
            value = this.cache.get(this.parentKey, ItemSetDomain.createCacheKey(this.getItemName() != null ? this.getItemName().toString() : null, this.getItemSetName() != null ? this.getItemSetName().toString() : null), ItemSet.class);
        }
        return value;
    }
}

