/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.inventory.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.inventory.Gs2InventoryRestClient;
import io.gs2.inventory.domain.model.InventoryModelMasterDomain;
import io.gs2.inventory.model.ItemModelMaster;
import io.gs2.inventory.request.DeleteItemModelMasterRequest;
import io.gs2.inventory.request.GetItemModelMasterRequest;
import io.gs2.inventory.request.UpdateItemModelMasterRequest;
import io.gs2.inventory.result.DeleteItemModelMasterResult;
import io.gs2.inventory.result.GetItemModelMasterResult;
import io.gs2.inventory.result.UpdateItemModelMasterResult;

public class ItemModelMasterDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2InventoryRestClient client;
    private final String namespaceName;
    private final String inventoryName;
    private final String itemName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getInventoryName() {
        return this.inventoryName;
    }

    public String getItemName() {
        return this.itemName;
    }

    public ItemModelMasterDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String inventoryName, String itemName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2InventoryRestClient(session);
        this.namespaceName = namespaceName;
        this.inventoryName = inventoryName;
        this.itemName = itemName;
        this.parentKey = InventoryModelMasterDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.inventoryName != null ? this.inventoryName.toString() : null, "ItemModelMaster");
    }

    private ItemModelMaster get(GetItemModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withInventoryName(this.inventoryName).withItemName(this.itemName);
        GetItemModelMasterResult result = this.client.getItemModelMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, ItemModelMasterDomain.createCacheKey(request.getItemName() != null ? request.getItemName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public ItemModelMasterDomain update(UpdateItemModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withInventoryName(this.inventoryName).withItemName(this.itemName);
        UpdateItemModelMasterResult result = this.client.updateItemModelMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, ItemModelMasterDomain.createCacheKey(request.getItemName() != null ? request.getItemName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        ItemModelMasterDomain domain = this;
        return domain;
    }

    public ItemModelMasterDomain delete(DeleteItemModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withInventoryName(this.inventoryName).withItemName(this.itemName);
        DeleteItemModelMasterResult result = null;
        try {
            result = this.client.deleteItemModelMaster(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, ItemModelMasterDomain.createCacheKey(request.getItemName() != null ? request.getItemName().toString() : null), ItemModelMaster.class);
        ItemModelMasterDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String inventoryName, String itemName, String childType) {
        return String.join((CharSequence)":", "inventory", namespaceName, inventoryName, itemName, childType);
    }

    public static String createCacheKey(String itemName) {
        return String.join((CharSequence)":", itemName);
    }

    public ItemModelMaster model() {
        ItemModelMaster value = this.cache.get(this.parentKey, ItemModelMasterDomain.createCacheKey(this.getItemName() != null ? this.getItemName().toString() : null), ItemModelMaster.class);
        if (value == null) {
            try {
                this.get(new GetItemModelMasterRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, ItemModelMasterDomain.createCacheKey(this.getItemName() != null ? this.getItemName().toString() : null), ItemModelMaster.class);
            }
            value = this.cache.get(this.parentKey, ItemModelMasterDomain.createCacheKey(this.getItemName() != null ? this.getItemName().toString() : null), ItemModelMaster.class);
        }
        return value;
    }
}

