/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.inventory.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.inventory.Gs2InventoryRestClient;
import io.gs2.inventory.domain.iterator.DescribeItemModelsIterator;
import io.gs2.inventory.domain.model.ItemModelDomain;
import io.gs2.inventory.domain.model.NamespaceDomain;
import io.gs2.inventory.model.InventoryModel;
import io.gs2.inventory.request.GetInventoryModelRequest;
import io.gs2.inventory.result.GetInventoryModelResult;

public class InventoryModelDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2InventoryRestClient client;
    private final String namespaceName;
    private final String inventoryName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getInventoryName() {
        return this.inventoryName;
    }

    public InventoryModelDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String inventoryName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2InventoryRestClient(session);
        this.namespaceName = namespaceName;
        this.inventoryName = inventoryName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "InventoryModel");
    }

    private InventoryModel get(GetInventoryModelRequest request) {
        request.withNamespaceName(this.namespaceName).withInventoryName(this.inventoryName);
        GetInventoryModelResult result = this.client.getInventoryModel(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, InventoryModelDomain.createCacheKey(request.getInventoryName() != null ? request.getInventoryName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public DescribeItemModelsIterator itemModels() {
        return new DescribeItemModelsIterator(this.cache, this.client, this.namespaceName, this.inventoryName);
    }

    public ItemModelDomain itemModel(String itemName) {
        return new ItemModelDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.inventoryName, itemName);
    }

    public static String createCacheParentKey(String namespaceName, String inventoryName, String childType) {
        return String.join((CharSequence)":", "inventory", namespaceName, inventoryName, childType);
    }

    public static String createCacheKey(String inventoryName) {
        return String.join((CharSequence)":", inventoryName);
    }

    public InventoryModel model() {
        InventoryModel value = this.cache.get(this.parentKey, InventoryModelDomain.createCacheKey(this.getInventoryName() != null ? this.getInventoryName().toString() : null), InventoryModel.class);
        if (value == null) {
            try {
                this.get(new GetInventoryModelRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, InventoryModelDomain.createCacheKey(this.getInventoryName() != null ? this.getInventoryName().toString() : null), InventoryModel.class);
            }
            value = this.cache.get(this.parentKey, InventoryModelDomain.createCacheKey(this.getInventoryName() != null ? this.getInventoryName().toString() : null), InventoryModel.class);
        }
        return value;
    }
}

