/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.inventory.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.inventory.Gs2InventoryRestClient;
import io.gs2.inventory.domain.iterator.DescribeItemSetsByUserIdIterator;
import io.gs2.inventory.domain.model.ItemSetDomain;
import io.gs2.inventory.domain.model.UserDomain;
import io.gs2.inventory.model.Inventory;
import io.gs2.inventory.request.AddCapacityByUserIdRequest;
import io.gs2.inventory.request.DeleteInventoryByUserIdRequest;
import io.gs2.inventory.request.GetInventoryByUserIdRequest;
import io.gs2.inventory.request.SetCapacityByUserIdRequest;
import io.gs2.inventory.result.AddCapacityByUserIdResult;
import io.gs2.inventory.result.DeleteInventoryByUserIdResult;
import io.gs2.inventory.result.GetInventoryByUserIdResult;
import io.gs2.inventory.result.SetCapacityByUserIdResult;

public class InventoryDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2InventoryRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String inventoryName;
    private final String parentKey;
    Long overflowCount;
    String nextPageToken;

    public Long getOverflowCount() {
        return this.overflowCount;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getInventoryName() {
        return this.inventoryName;
    }

    public InventoryDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId, String inventoryName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2InventoryRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.inventoryName = inventoryName;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Inventory");
    }

    private Inventory get(GetInventoryByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withInventoryName(this.inventoryName);
        GetInventoryByUserIdResult result = this.client.getInventoryByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, InventoryDomain.createCacheKey(request.getInventoryName() != null ? request.getInventoryName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public InventoryDomain addCapacity(AddCapacityByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withInventoryName(this.inventoryName);
        AddCapacityByUserIdResult result = this.client.addCapacityByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, InventoryDomain.createCacheKey(request.getInventoryName() != null ? request.getInventoryName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        InventoryDomain domain = this;
        return domain;
    }

    public InventoryDomain setCapacity(SetCapacityByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withInventoryName(this.inventoryName);
        SetCapacityByUserIdResult result = this.client.setCapacityByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, InventoryDomain.createCacheKey(request.getInventoryName() != null ? request.getInventoryName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        InventoryDomain domain = this;
        return domain;
    }

    public InventoryDomain delete(DeleteInventoryByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withInventoryName(this.inventoryName);
        DeleteInventoryByUserIdResult result = null;
        try {
            result = this.client.deleteInventoryByUserId(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, InventoryDomain.createCacheKey(request.getInventoryName() != null ? request.getInventoryName().toString() : null), Inventory.class);
        InventoryDomain domain = this;
        return domain;
    }

    public DescribeItemSetsByUserIdIterator itemSets() {
        return new DescribeItemSetsByUserIdIterator(this.cache, this.client, this.namespaceName, this.inventoryName, this.userId);
    }

    public ItemSetDomain itemSet(String itemName, String itemSetName) {
        return new ItemSetDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.userId, this.inventoryName, itemName, itemSetName);
    }

    public static String createCacheParentKey(String namespaceName, String userId, String inventoryName, String childType) {
        return String.join((CharSequence)":", "inventory", namespaceName, userId, inventoryName, childType);
    }

    public static String createCacheKey(String inventoryName) {
        return String.join((CharSequence)":", inventoryName);
    }

    public Inventory model() {
        Inventory value = this.cache.get(this.parentKey, InventoryDomain.createCacheKey(this.getInventoryName() != null ? this.getInventoryName().toString() : null), Inventory.class);
        if (value == null) {
            try {
                this.get(new GetInventoryByUserIdRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, InventoryDomain.createCacheKey(this.getInventoryName() != null ? this.getInventoryName().toString() : null), Inventory.class);
            }
            value = this.cache.get(this.parentKey, InventoryDomain.createCacheKey(this.getInventoryName() != null ? this.getInventoryName().toString() : null), Inventory.class);
        }
        return value;
    }
}

