/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.inventory.domain.iterator;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.inventory.Gs2InventoryRestClient;
import io.gs2.inventory.request.DescribeReferenceOfRequest;
import io.gs2.inventory.result.DescribeReferenceOfResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeReferenceOfIterator
implements Iterator<String>,
Iterable<String> {
    CacheDatabase cache;
    Gs2InventoryRestClient client;
    String namespaceName;
    String inventoryName;
    AccessToken accessToken;
    String itemName;
    String itemSetName;
    boolean last;
    List<String> result;
    Integer fetchSize;

    public DescribeReferenceOfIterator(CacheDatabase cache, Gs2InventoryRestClient client, String namespaceName, String inventoryName, AccessToken accessToken, String itemName, String itemSetName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.inventoryName = inventoryName;
        this.accessToken = accessToken;
        this.itemName = itemName;
        this.itemSetName = itemSetName;
        this.last = false;
        this.result = new ArrayList<String>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = "inventory:String";
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, String.class)) {
            this.result = this.cache.list(parentKey, String.class).stream().collect(Collectors.toList());
            this.last = true;
        } else {
            DescribeReferenceOfResult r = this.client.describeReferenceOf(new DescribeReferenceOfRequest().withNamespaceName(this.namespaceName).withInventoryName(this.inventoryName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withItemName(this.itemName).withItemSetName(this.itemSetName));
            this.result = r.getItems();
            this.last = true;
            for (String item : this.result) {
                this.cache.put(parentKey, item, item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, String.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public String next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        String ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }
}

