/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.inventory.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.inventory.Gs2InventoryRestClient;
import io.gs2.inventory.domain.model.NamespaceDomain;
import io.gs2.inventory.model.Namespace;
import io.gs2.inventory.request.DescribeNamespacesRequest;
import io.gs2.inventory.result.DescribeNamespacesResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeNamespacesIterator
implements Iterator<Namespace>,
Iterable<Namespace> {
    CacheDatabase cache;
    Gs2InventoryRestClient client;
    String pageToken;
    boolean last;
    List<Namespace> result;
    Integer fetchSize;

    public DescribeNamespacesIterator(CacheDatabase cache, Gs2InventoryRestClient client) {
        this.cache = cache;
        this.client = client;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<Namespace>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = "inventory:Namespace";
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, Namespace.class)) {
            this.result = this.cache.list(parentKey, Namespace.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeNamespacesResult r = this.client.describeNamespaces(new DescribeNamespacesRequest().withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (Namespace item : this.result) {
                this.cache.put(parentKey, NamespaceDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, Namespace.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public Namespace next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        Namespace ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<Namespace> iterator() {
        return this;
    }
}

