/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.inventory.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.inventory.Gs2InventoryRestClient;
import io.gs2.inventory.domain.model.InventoryModelMasterDomain;
import io.gs2.inventory.domain.model.ItemModelMasterDomain;
import io.gs2.inventory.model.ItemModelMaster;
import io.gs2.inventory.request.DescribeItemModelMastersRequest;
import io.gs2.inventory.result.DescribeItemModelMastersResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeItemModelMastersIterator
implements Iterator<ItemModelMaster>,
Iterable<ItemModelMaster> {
    CacheDatabase cache;
    Gs2InventoryRestClient client;
    String namespaceName;
    String inventoryName;
    String pageToken;
    boolean last;
    List<ItemModelMaster> result;
    Integer fetchSize;

    public DescribeItemModelMastersIterator(CacheDatabase cache, Gs2InventoryRestClient client, String namespaceName, String inventoryName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.inventoryName = inventoryName;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<ItemModelMaster>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = InventoryModelMasterDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.inventoryName != null ? this.inventoryName.toString() : null, "ItemModelMaster");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, ItemModelMaster.class)) {
            this.result = this.cache.list(parentKey, ItemModelMaster.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeItemModelMastersResult r = this.client.describeItemModelMasters(new DescribeItemModelMastersRequest().withNamespaceName(this.namespaceName).withInventoryName(this.inventoryName).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (ItemModelMaster item : this.result) {
                this.cache.put(parentKey, ItemModelMasterDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, ItemModelMaster.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public ItemModelMaster next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        ItemModelMaster ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<ItemModelMaster> iterator() {
        return this;
    }
}

