/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.inventory.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.inventory.Gs2InventoryRestClient;
import io.gs2.inventory.domain.model.InventoryModelDomain;
import io.gs2.inventory.domain.model.NamespaceDomain;
import io.gs2.inventory.model.InventoryModel;
import io.gs2.inventory.request.DescribeInventoryModelsRequest;
import io.gs2.inventory.result.DescribeInventoryModelsResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeInventoryModelsIterator
implements Iterator<InventoryModel>,
Iterable<InventoryModel> {
    CacheDatabase cache;
    Gs2InventoryRestClient client;
    String namespaceName;
    boolean last;
    List<InventoryModel> result;
    Integer fetchSize;

    public DescribeInventoryModelsIterator(CacheDatabase cache, Gs2InventoryRestClient client, String namespaceName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.last = false;
        this.result = new ArrayList<InventoryModel>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "InventoryModel");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, InventoryModel.class)) {
            this.result = this.cache.list(parentKey, InventoryModel.class).stream().collect(Collectors.toList());
            this.last = true;
        } else {
            DescribeInventoryModelsResult r = this.client.describeInventoryModels(new DescribeInventoryModelsRequest().withNamespaceName(this.namespaceName));
            this.result = r.getItems();
            this.last = true;
            for (InventoryModel item : this.result) {
                this.cache.put(parentKey, InventoryModelDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, InventoryModel.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public InventoryModel next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        InventoryModel ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<InventoryModel> iterator() {
        return this;
    }
}

