/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.inbox.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.inbox.Gs2InboxRestClient;
import io.gs2.inbox.domain.model.GlobalMessageDomain;
import io.gs2.inbox.domain.model.NamespaceDomain;
import io.gs2.inbox.model.GlobalMessage;
import io.gs2.inbox.request.DescribeGlobalMessagesRequest;
import io.gs2.inbox.result.DescribeGlobalMessagesResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeGlobalMessagesIterator
implements Iterator<GlobalMessage>,
Iterable<GlobalMessage> {
    CacheDatabase cache;
    Gs2InboxRestClient client;
    String namespaceName;
    boolean last;
    List<GlobalMessage> result;
    Integer fetchSize;

    public DescribeGlobalMessagesIterator(CacheDatabase cache, Gs2InboxRestClient client, String namespaceName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.last = false;
        this.result = new ArrayList<GlobalMessage>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "GlobalMessage");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, GlobalMessage.class)) {
            this.result = this.cache.list(parentKey, GlobalMessage.class).stream().collect(Collectors.toList());
            this.last = true;
        } else {
            DescribeGlobalMessagesResult r = this.client.describeGlobalMessages(new DescribeGlobalMessagesRequest().withNamespaceName(this.namespaceName));
            this.result = r.getItems();
            this.last = true;
            for (GlobalMessage item : this.result) {
                this.cache.put(parentKey, GlobalMessageDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, GlobalMessage.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public GlobalMessage next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        GlobalMessage ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<GlobalMessage> iterator() {
        return this;
    }
}

