/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.identifier.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.identifier.Gs2IdentifierRestClient;
import io.gs2.identifier.model.SecurityPolicy;
import io.gs2.identifier.request.DeleteSecurityPolicyRequest;
import io.gs2.identifier.request.GetSecurityPolicyRequest;
import io.gs2.identifier.request.UpdateSecurityPolicyRequest;
import io.gs2.identifier.result.DeleteSecurityPolicyResult;
import io.gs2.identifier.result.GetSecurityPolicyResult;
import io.gs2.identifier.result.UpdateSecurityPolicyResult;

public class SecurityPolicyDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2IdentifierRestClient client;
    private final String securityPolicyName;
    private final String parentKey;

    public String getSecurityPolicyName() {
        return this.securityPolicyName;
    }

    public SecurityPolicyDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String securityPolicyName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2IdentifierRestClient(session);
        this.securityPolicyName = securityPolicyName;
        this.parentKey = "identifier:SecurityPolicy";
    }

    public SecurityPolicyDomain update(UpdateSecurityPolicyRequest request) {
        request.withSecurityPolicyName(this.securityPolicyName);
        UpdateSecurityPolicyResult result = this.client.updateSecurityPolicy(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, SecurityPolicyDomain.createCacheKey(request.getSecurityPolicyName() != null ? request.getSecurityPolicyName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        SecurityPolicyDomain domain = this;
        return domain;
    }

    private SecurityPolicy get(GetSecurityPolicyRequest request) {
        request.withSecurityPolicyName(this.securityPolicyName);
        GetSecurityPolicyResult result = this.client.getSecurityPolicy(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, SecurityPolicyDomain.createCacheKey(request.getSecurityPolicyName() != null ? request.getSecurityPolicyName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public SecurityPolicyDomain delete(DeleteSecurityPolicyRequest request) {
        request.withSecurityPolicyName(this.securityPolicyName);
        DeleteSecurityPolicyResult result = null;
        try {
            result = this.client.deleteSecurityPolicy(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, SecurityPolicyDomain.createCacheKey(request.getSecurityPolicyName() != null ? request.getSecurityPolicyName().toString() : null), SecurityPolicy.class);
        SecurityPolicyDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String securityPolicyName, String childType) {
        return String.join((CharSequence)":", "identifier", securityPolicyName, childType);
    }

    public static String createCacheKey(String securityPolicyName) {
        return String.join((CharSequence)":", securityPolicyName);
    }

    public SecurityPolicy model() {
        SecurityPolicy value = this.cache.get(this.parentKey, SecurityPolicyDomain.createCacheKey(this.getSecurityPolicyName() != null ? this.getSecurityPolicyName().toString() : null), SecurityPolicy.class);
        if (value == null) {
            try {
                this.get(new GetSecurityPolicyRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, SecurityPolicyDomain.createCacheKey(this.getSecurityPolicyName() != null ? this.getSecurityPolicyName().toString() : null), SecurityPolicy.class);
            }
            value = this.cache.get(this.parentKey, SecurityPolicyDomain.createCacheKey(this.getSecurityPolicyName() != null ? this.getSecurityPolicyName().toString() : null), SecurityPolicy.class);
        }
        return value;
    }
}

