/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.identifier.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.identifier.Gs2IdentifierRestClient;
import io.gs2.identifier.domain.model.UserDomain;
import io.gs2.identifier.model.Password;
import io.gs2.identifier.request.CreatePasswordRequest;
import io.gs2.identifier.request.DeletePasswordRequest;
import io.gs2.identifier.request.GetPasswordRequest;
import io.gs2.identifier.result.CreatePasswordResult;
import io.gs2.identifier.result.DeletePasswordResult;
import io.gs2.identifier.result.GetPasswordResult;

public class PasswordDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2IdentifierRestClient client;
    private final String userName;
    private final String parentKey;

    public String getUserName() {
        return this.userName;
    }

    public PasswordDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String userName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2IdentifierRestClient(session);
        this.userName = userName;
        this.parentKey = UserDomain.createCacheParentKey(this.userName != null ? this.userName.toString() : null, "Password");
    }

    public PasswordDomain create(CreatePasswordRequest request) {
        request.withUserName(this.userName);
        CreatePasswordResult result = this.client.createPassword(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, PasswordDomain.createCacheKey(request.getUserName() != null ? request.getUserName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        PasswordDomain domain = this;
        return domain;
    }

    private Password get(GetPasswordRequest request) {
        request.withUserName(this.userName);
        GetPasswordResult result = this.client.getPassword(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, PasswordDomain.createCacheKey(request.getUserName() != null ? request.getUserName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public PasswordDomain delete(DeletePasswordRequest request) {
        request.withUserName(this.userName);
        DeletePasswordResult result = null;
        try {
            result = this.client.deletePassword(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, PasswordDomain.createCacheKey(request.getUserName() != null ? request.getUserName().toString() : null), Password.class);
        PasswordDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String userName, String childType) {
        return String.join((CharSequence)":", "identifier", userName, childType);
    }

    public static String createCacheKey(String userName) {
        return String.join((CharSequence)":", userName);
    }

    public Password model() {
        Password value = this.cache.get(this.parentKey, PasswordDomain.createCacheKey(this.getUserName() != null ? this.getUserName().toString() : null), Password.class);
        if (value == null) {
            try {
                this.get(new GetPasswordRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, PasswordDomain.createCacheKey(this.getUserName() != null ? this.getUserName().toString() : null), Password.class);
            }
            value = this.cache.get(this.parentKey, PasswordDomain.createCacheKey(this.getUserName() != null ? this.getUserName().toString() : null), Password.class);
        }
        return value;
    }
}

