/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.identifier.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.identifier.Gs2IdentifierRestClient;
import io.gs2.identifier.domain.model.UserDomain;
import io.gs2.identifier.model.User;
import io.gs2.identifier.request.DescribeUsersRequest;
import io.gs2.identifier.result.DescribeUsersResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeUsersIterator
implements Iterator<User>,
Iterable<User> {
    CacheDatabase cache;
    Gs2IdentifierRestClient client;
    String pageToken;
    boolean last;
    List<User> result;
    Integer fetchSize;

    public DescribeUsersIterator(CacheDatabase cache, Gs2IdentifierRestClient client) {
        this.cache = cache;
        this.client = client;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<User>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = "identifier:User";
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, User.class)) {
            this.result = this.cache.list(parentKey, User.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeUsersResult r = this.client.describeUsers(new DescribeUsersRequest().withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (User item : this.result) {
                this.cache.put(parentKey, UserDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, User.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public User next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        User ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<User> iterator() {
        return this;
    }
}

