/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.identifier;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.AbstractGs2Client;
import io.gs2.core.model.AsyncAction;
import io.gs2.core.model.AsyncResult;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.core.net.Gs2RestSessionTask;
import io.gs2.core.net.HttpTask;
import io.gs2.core.util.EncodingUtil;
import io.gs2.identifier.request.AttachSecurityPolicyRequest;
import io.gs2.identifier.request.CreateIdentifierRequest;
import io.gs2.identifier.request.CreatePasswordRequest;
import io.gs2.identifier.request.CreateSecurityPolicyRequest;
import io.gs2.identifier.request.CreateUserRequest;
import io.gs2.identifier.request.DeleteIdentifierRequest;
import io.gs2.identifier.request.DeletePasswordRequest;
import io.gs2.identifier.request.DeleteSecurityPolicyRequest;
import io.gs2.identifier.request.DeleteUserRequest;
import io.gs2.identifier.request.DescribeCommonSecurityPoliciesRequest;
import io.gs2.identifier.request.DescribeIdentifiersRequest;
import io.gs2.identifier.request.DescribePasswordsRequest;
import io.gs2.identifier.request.DescribeSecurityPoliciesRequest;
import io.gs2.identifier.request.DescribeUsersRequest;
import io.gs2.identifier.request.DetachSecurityPolicyRequest;
import io.gs2.identifier.request.GetHasSecurityPolicyRequest;
import io.gs2.identifier.request.GetIdentifierRequest;
import io.gs2.identifier.request.GetPasswordRequest;
import io.gs2.identifier.request.GetSecurityPolicyRequest;
import io.gs2.identifier.request.GetUserRequest;
import io.gs2.identifier.request.LoginByUserRequest;
import io.gs2.identifier.request.LoginRequest;
import io.gs2.identifier.request.UpdateSecurityPolicyRequest;
import io.gs2.identifier.request.UpdateUserRequest;
import io.gs2.identifier.result.AttachSecurityPolicyResult;
import io.gs2.identifier.result.CreateIdentifierResult;
import io.gs2.identifier.result.CreatePasswordResult;
import io.gs2.identifier.result.CreateSecurityPolicyResult;
import io.gs2.identifier.result.CreateUserResult;
import io.gs2.identifier.result.DeleteIdentifierResult;
import io.gs2.identifier.result.DeletePasswordResult;
import io.gs2.identifier.result.DeleteSecurityPolicyResult;
import io.gs2.identifier.result.DeleteUserResult;
import io.gs2.identifier.result.DescribeCommonSecurityPoliciesResult;
import io.gs2.identifier.result.DescribeIdentifiersResult;
import io.gs2.identifier.result.DescribePasswordsResult;
import io.gs2.identifier.result.DescribeSecurityPoliciesResult;
import io.gs2.identifier.result.DescribeUsersResult;
import io.gs2.identifier.result.DetachSecurityPolicyResult;
import io.gs2.identifier.result.GetHasSecurityPolicyResult;
import io.gs2.identifier.result.GetIdentifierResult;
import io.gs2.identifier.result.GetPasswordResult;
import io.gs2.identifier.result.GetSecurityPolicyResult;
import io.gs2.identifier.result.GetUserResult;
import io.gs2.identifier.result.LoginByUserResult;
import io.gs2.identifier.result.LoginResult;
import io.gs2.identifier.result.UpdateSecurityPolicyResult;
import io.gs2.identifier.result.UpdateUserResult;
import java.util.ArrayList;
import java.util.HashMap;

public class Gs2IdentifierRestClient
extends AbstractGs2Client<Gs2IdentifierRestClient> {
    public Gs2IdentifierRestClient(Gs2RestSession gs2RestSession) {
        super(gs2RestSession);
    }

    public void describeUsersAsync(DescribeUsersRequest request, AsyncAction<AsyncResult<DescribeUsersResult>> callback) {
        DescribeUsersTask task = new DescribeUsersTask(request, callback);
        this.session.execute(task);
    }

    public DescribeUsersResult describeUsers(DescribeUsersRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeUsersAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeUsersResult)resultAsyncResult[0].getResult();
    }

    public void createUserAsync(CreateUserRequest request, AsyncAction<AsyncResult<CreateUserResult>> callback) {
        CreateUserTask task = new CreateUserTask(request, callback);
        this.session.execute(task);
    }

    public CreateUserResult createUser(CreateUserRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createUserAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateUserResult)resultAsyncResult[0].getResult();
    }

    public void updateUserAsync(UpdateUserRequest request, AsyncAction<AsyncResult<UpdateUserResult>> callback) {
        UpdateUserTask task = new UpdateUserTask(request, callback);
        this.session.execute(task);
    }

    public UpdateUserResult updateUser(UpdateUserRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateUserAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateUserResult)resultAsyncResult[0].getResult();
    }

    public void getUserAsync(GetUserRequest request, AsyncAction<AsyncResult<GetUserResult>> callback) {
        GetUserTask task = new GetUserTask(request, callback);
        this.session.execute(task);
    }

    public GetUserResult getUser(GetUserRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getUserAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetUserResult)resultAsyncResult[0].getResult();
    }

    public void deleteUserAsync(DeleteUserRequest request, AsyncAction<AsyncResult<DeleteUserResult>> callback) {
        DeleteUserTask task = new DeleteUserTask(request, callback);
        this.session.execute(task);
    }

    public DeleteUserResult deleteUser(DeleteUserRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteUserAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteUserResult)resultAsyncResult[0].getResult();
    }

    public void describeSecurityPoliciesAsync(DescribeSecurityPoliciesRequest request, AsyncAction<AsyncResult<DescribeSecurityPoliciesResult>> callback) {
        DescribeSecurityPoliciesTask task = new DescribeSecurityPoliciesTask(request, callback);
        this.session.execute(task);
    }

    public DescribeSecurityPoliciesResult describeSecurityPolicies(DescribeSecurityPoliciesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeSecurityPoliciesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeSecurityPoliciesResult)resultAsyncResult[0].getResult();
    }

    public void describeCommonSecurityPoliciesAsync(DescribeCommonSecurityPoliciesRequest request, AsyncAction<AsyncResult<DescribeCommonSecurityPoliciesResult>> callback) {
        DescribeCommonSecurityPoliciesTask task = new DescribeCommonSecurityPoliciesTask(request, callback);
        this.session.execute(task);
    }

    public DescribeCommonSecurityPoliciesResult describeCommonSecurityPolicies(DescribeCommonSecurityPoliciesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeCommonSecurityPoliciesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeCommonSecurityPoliciesResult)resultAsyncResult[0].getResult();
    }

    public void createSecurityPolicyAsync(CreateSecurityPolicyRequest request, AsyncAction<AsyncResult<CreateSecurityPolicyResult>> callback) {
        CreateSecurityPolicyTask task = new CreateSecurityPolicyTask(request, callback);
        this.session.execute(task);
    }

    public CreateSecurityPolicyResult createSecurityPolicy(CreateSecurityPolicyRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createSecurityPolicyAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateSecurityPolicyResult)resultAsyncResult[0].getResult();
    }

    public void updateSecurityPolicyAsync(UpdateSecurityPolicyRequest request, AsyncAction<AsyncResult<UpdateSecurityPolicyResult>> callback) {
        UpdateSecurityPolicyTask task = new UpdateSecurityPolicyTask(request, callback);
        this.session.execute(task);
    }

    public UpdateSecurityPolicyResult updateSecurityPolicy(UpdateSecurityPolicyRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateSecurityPolicyAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateSecurityPolicyResult)resultAsyncResult[0].getResult();
    }

    public void getSecurityPolicyAsync(GetSecurityPolicyRequest request, AsyncAction<AsyncResult<GetSecurityPolicyResult>> callback) {
        GetSecurityPolicyTask task = new GetSecurityPolicyTask(request, callback);
        this.session.execute(task);
    }

    public GetSecurityPolicyResult getSecurityPolicy(GetSecurityPolicyRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getSecurityPolicyAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetSecurityPolicyResult)resultAsyncResult[0].getResult();
    }

    public void deleteSecurityPolicyAsync(DeleteSecurityPolicyRequest request, AsyncAction<AsyncResult<DeleteSecurityPolicyResult>> callback) {
        DeleteSecurityPolicyTask task = new DeleteSecurityPolicyTask(request, callback);
        this.session.execute(task);
    }

    public DeleteSecurityPolicyResult deleteSecurityPolicy(DeleteSecurityPolicyRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteSecurityPolicyAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteSecurityPolicyResult)resultAsyncResult[0].getResult();
    }

    public void describeIdentifiersAsync(DescribeIdentifiersRequest request, AsyncAction<AsyncResult<DescribeIdentifiersResult>> callback) {
        DescribeIdentifiersTask task = new DescribeIdentifiersTask(request, callback);
        this.session.execute(task);
    }

    public DescribeIdentifiersResult describeIdentifiers(DescribeIdentifiersRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeIdentifiersAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeIdentifiersResult)resultAsyncResult[0].getResult();
    }

    public void createIdentifierAsync(CreateIdentifierRequest request, AsyncAction<AsyncResult<CreateIdentifierResult>> callback) {
        CreateIdentifierTask task = new CreateIdentifierTask(request, callback);
        this.session.execute(task);
    }

    public CreateIdentifierResult createIdentifier(CreateIdentifierRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createIdentifierAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateIdentifierResult)resultAsyncResult[0].getResult();
    }

    public void getIdentifierAsync(GetIdentifierRequest request, AsyncAction<AsyncResult<GetIdentifierResult>> callback) {
        GetIdentifierTask task = new GetIdentifierTask(request, callback);
        this.session.execute(task);
    }

    public GetIdentifierResult getIdentifier(GetIdentifierRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getIdentifierAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetIdentifierResult)resultAsyncResult[0].getResult();
    }

    public void deleteIdentifierAsync(DeleteIdentifierRequest request, AsyncAction<AsyncResult<DeleteIdentifierResult>> callback) {
        DeleteIdentifierTask task = new DeleteIdentifierTask(request, callback);
        this.session.execute(task);
    }

    public DeleteIdentifierResult deleteIdentifier(DeleteIdentifierRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteIdentifierAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteIdentifierResult)resultAsyncResult[0].getResult();
    }

    public void describePasswordsAsync(DescribePasswordsRequest request, AsyncAction<AsyncResult<DescribePasswordsResult>> callback) {
        DescribePasswordsTask task = new DescribePasswordsTask(request, callback);
        this.session.execute(task);
    }

    public DescribePasswordsResult describePasswords(DescribePasswordsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describePasswordsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribePasswordsResult)resultAsyncResult[0].getResult();
    }

    public void createPasswordAsync(CreatePasswordRequest request, AsyncAction<AsyncResult<CreatePasswordResult>> callback) {
        CreatePasswordTask task = new CreatePasswordTask(request, callback);
        this.session.execute(task);
    }

    public CreatePasswordResult createPassword(CreatePasswordRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createPasswordAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreatePasswordResult)resultAsyncResult[0].getResult();
    }

    public void getPasswordAsync(GetPasswordRequest request, AsyncAction<AsyncResult<GetPasswordResult>> callback) {
        GetPasswordTask task = new GetPasswordTask(request, callback);
        this.session.execute(task);
    }

    public GetPasswordResult getPassword(GetPasswordRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getPasswordAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetPasswordResult)resultAsyncResult[0].getResult();
    }

    public void deletePasswordAsync(DeletePasswordRequest request, AsyncAction<AsyncResult<DeletePasswordResult>> callback) {
        DeletePasswordTask task = new DeletePasswordTask(request, callback);
        this.session.execute(task);
    }

    public DeletePasswordResult deletePassword(DeletePasswordRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deletePasswordAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeletePasswordResult)resultAsyncResult[0].getResult();
    }

    public void getHasSecurityPolicyAsync(GetHasSecurityPolicyRequest request, AsyncAction<AsyncResult<GetHasSecurityPolicyResult>> callback) {
        GetHasSecurityPolicyTask task = new GetHasSecurityPolicyTask(request, callback);
        this.session.execute(task);
    }

    public GetHasSecurityPolicyResult getHasSecurityPolicy(GetHasSecurityPolicyRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getHasSecurityPolicyAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetHasSecurityPolicyResult)resultAsyncResult[0].getResult();
    }

    public void attachSecurityPolicyAsync(AttachSecurityPolicyRequest request, AsyncAction<AsyncResult<AttachSecurityPolicyResult>> callback) {
        AttachSecurityPolicyTask task = new AttachSecurityPolicyTask(request, callback);
        this.session.execute(task);
    }

    public AttachSecurityPolicyResult attachSecurityPolicy(AttachSecurityPolicyRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.attachSecurityPolicyAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (AttachSecurityPolicyResult)resultAsyncResult[0].getResult();
    }

    public void detachSecurityPolicyAsync(DetachSecurityPolicyRequest request, AsyncAction<AsyncResult<DetachSecurityPolicyResult>> callback) {
        DetachSecurityPolicyTask task = new DetachSecurityPolicyTask(request, callback);
        this.session.execute(task);
    }

    public DetachSecurityPolicyResult detachSecurityPolicy(DetachSecurityPolicyRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.detachSecurityPolicyAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DetachSecurityPolicyResult)resultAsyncResult[0].getResult();
    }

    public void loginAsync(LoginRequest request, AsyncAction<AsyncResult<LoginResult>> callback) {
        LoginTask task = new LoginTask(request, callback);
        this.session.execute(task);
    }

    public LoginResult login(LoginRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.loginAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (LoginResult)resultAsyncResult[0].getResult();
    }

    public void loginByUserAsync(LoginByUserRequest request, AsyncAction<AsyncResult<LoginByUserResult>> callback) {
        LoginByUserTask task = new LoginByUserTask(request, callback);
        this.session.execute(task);
    }

    public LoginByUserResult loginByUser(LoginByUserRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.loginByUserAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (LoginByUserResult)resultAsyncResult[0].getResult();
    }

    class LoginByUserTask
    extends Gs2RestSessionTask<LoginByUserResult> {
        private LoginByUserRequest request;

        public LoginByUserTask(LoginByUserRequest request, AsyncAction<AsyncResult<LoginByUserResult>> userCallback) {
            super((Gs2RestSession)Gs2IdentifierRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public LoginByUserResult parse(JsonNode data) {
            return LoginByUserResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "identifier").replace("{region}", Gs2IdentifierRestClient.this.session.getRegion().getName()) + "/projectToken/login/user";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("userName", LoginByUserTask.this.request.getUserName());
                    this.put("password", LoginByUserTask.this.request.getPassword());
                    this.put("contextStack", LoginByUserTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class LoginTask
    extends Gs2RestSessionTask<LoginResult> {
        private LoginRequest request;

        public LoginTask(LoginRequest request, AsyncAction<AsyncResult<LoginResult>> userCallback) {
            super((Gs2RestSession)Gs2IdentifierRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public LoginResult parse(JsonNode data) {
            return LoginResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "identifier").replace("{region}", Gs2IdentifierRestClient.this.session.getRegion().getName()) + "/projectToken/login";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("client_id", LoginTask.this.request.getClientId());
                    this.put("client_secret", LoginTask.this.request.getClientSecret());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DetachSecurityPolicyTask
    extends Gs2RestSessionTask<DetachSecurityPolicyResult> {
        private DetachSecurityPolicyRequest request;

        public DetachSecurityPolicyTask(DetachSecurityPolicyRequest request, AsyncAction<AsyncResult<DetachSecurityPolicyResult>> userCallback) {
            super((Gs2RestSession)Gs2IdentifierRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DetachSecurityPolicyResult parse(JsonNode data) {
            return DetachSecurityPolicyResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "identifier").replace("{region}", Gs2IdentifierRestClient.this.session.getRegion().getName()) + "/user/{userName}/securityPolicy/{securityPolicyId}";
            url = url.replace("{userName}", this.request.getUserName() == null || this.request.getUserName().length() == 0 ? "null" : String.valueOf(this.request.getUserName()));
            url = url.replace("{securityPolicyId}", this.request.getSecurityPolicyId() == null || this.request.getSecurityPolicyId().length() == 0 ? "null" : String.valueOf(this.request.getSecurityPolicyId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class AttachSecurityPolicyTask
    extends Gs2RestSessionTask<AttachSecurityPolicyResult> {
        private AttachSecurityPolicyRequest request;

        public AttachSecurityPolicyTask(AttachSecurityPolicyRequest request, AsyncAction<AsyncResult<AttachSecurityPolicyResult>> userCallback) {
            super((Gs2RestSession)Gs2IdentifierRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public AttachSecurityPolicyResult parse(JsonNode data) {
            return AttachSecurityPolicyResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "identifier").replace("{region}", Gs2IdentifierRestClient.this.session.getRegion().getName()) + "/user/{userName}/securityPolicy";
            url = url.replace("{userName}", this.request.getUserName() == null || this.request.getUserName().length() == 0 ? "null" : String.valueOf(this.request.getUserName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("securityPolicyId", AttachSecurityPolicyTask.this.request.getSecurityPolicyId());
                    this.put("contextStack", AttachSecurityPolicyTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetHasSecurityPolicyTask
    extends Gs2RestSessionTask<GetHasSecurityPolicyResult> {
        private GetHasSecurityPolicyRequest request;

        public GetHasSecurityPolicyTask(GetHasSecurityPolicyRequest request, AsyncAction<AsyncResult<GetHasSecurityPolicyResult>> userCallback) {
            super((Gs2RestSession)Gs2IdentifierRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetHasSecurityPolicyResult parse(JsonNode data) {
            return GetHasSecurityPolicyResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "identifier").replace("{region}", Gs2IdentifierRestClient.this.session.getRegion().getName()) + "/user/{userName}/securityPolicy";
            url = url.replace("{userName}", this.request.getUserName() == null || this.request.getUserName().length() == 0 ? "null" : String.valueOf(this.request.getUserName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeletePasswordTask
    extends Gs2RestSessionTask<DeletePasswordResult> {
        private DeletePasswordRequest request;

        public DeletePasswordTask(DeletePasswordRequest request, AsyncAction<AsyncResult<DeletePasswordResult>> userCallback) {
            super((Gs2RestSession)Gs2IdentifierRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeletePasswordResult parse(JsonNode data) {
            return DeletePasswordResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "identifier").replace("{region}", Gs2IdentifierRestClient.this.session.getRegion().getName()) + "/user/{userName}/password/entity";
            url = url.replace("{userName}", this.request.getUserName() == null || this.request.getUserName().length() == 0 ? "null" : String.valueOf(this.request.getUserName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetPasswordTask
    extends Gs2RestSessionTask<GetPasswordResult> {
        private GetPasswordRequest request;

        public GetPasswordTask(GetPasswordRequest request, AsyncAction<AsyncResult<GetPasswordResult>> userCallback) {
            super((Gs2RestSession)Gs2IdentifierRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetPasswordResult parse(JsonNode data) {
            return GetPasswordResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "identifier").replace("{region}", Gs2IdentifierRestClient.this.session.getRegion().getName()) + "/user/{userName}/password/entity";
            url = url.replace("{userName}", this.request.getUserName() == null || this.request.getUserName().length() == 0 ? "null" : String.valueOf(this.request.getUserName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreatePasswordTask
    extends Gs2RestSessionTask<CreatePasswordResult> {
        private CreatePasswordRequest request;

        public CreatePasswordTask(CreatePasswordRequest request, AsyncAction<AsyncResult<CreatePasswordResult>> userCallback) {
            super((Gs2RestSession)Gs2IdentifierRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreatePasswordResult parse(JsonNode data) {
            return CreatePasswordResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "identifier").replace("{region}", Gs2IdentifierRestClient.this.session.getRegion().getName()) + "/user/{userName}/password";
            url = url.replace("{userName}", this.request.getUserName() == null || this.request.getUserName().length() == 0 ? "null" : String.valueOf(this.request.getUserName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("password", CreatePasswordTask.this.request.getPassword());
                    this.put("contextStack", CreatePasswordTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribePasswordsTask
    extends Gs2RestSessionTask<DescribePasswordsResult> {
        private DescribePasswordsRequest request;

        public DescribePasswordsTask(DescribePasswordsRequest request, AsyncAction<AsyncResult<DescribePasswordsResult>> userCallback) {
            super((Gs2RestSession)Gs2IdentifierRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribePasswordsResult parse(JsonNode data) {
            return DescribePasswordsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "identifier").replace("{region}", Gs2IdentifierRestClient.this.session.getRegion().getName()) + "/user/{userName}/password";
            url = url.replace("{userName}", this.request.getUserName() == null || this.request.getUserName().length() == 0 ? "null" : String.valueOf(this.request.getUserName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteIdentifierTask
    extends Gs2RestSessionTask<DeleteIdentifierResult> {
        private DeleteIdentifierRequest request;

        public DeleteIdentifierTask(DeleteIdentifierRequest request, AsyncAction<AsyncResult<DeleteIdentifierResult>> userCallback) {
            super((Gs2RestSession)Gs2IdentifierRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteIdentifierResult parse(JsonNode data) {
            return DeleteIdentifierResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "identifier").replace("{region}", Gs2IdentifierRestClient.this.session.getRegion().getName()) + "/user/{userName}/identifier/{clientId}";
            url = url.replace("{userName}", this.request.getUserName() == null || this.request.getUserName().length() == 0 ? "null" : String.valueOf(this.request.getUserName()));
            url = url.replace("{clientId}", this.request.getClientId() == null || this.request.getClientId().length() == 0 ? "null" : String.valueOf(this.request.getClientId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetIdentifierTask
    extends Gs2RestSessionTask<GetIdentifierResult> {
        private GetIdentifierRequest request;

        public GetIdentifierTask(GetIdentifierRequest request, AsyncAction<AsyncResult<GetIdentifierResult>> userCallback) {
            super((Gs2RestSession)Gs2IdentifierRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetIdentifierResult parse(JsonNode data) {
            return GetIdentifierResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "identifier").replace("{region}", Gs2IdentifierRestClient.this.session.getRegion().getName()) + "/user/{userName}/identifier/{clientId}";
            url = url.replace("{userName}", this.request.getUserName() == null || this.request.getUserName().length() == 0 ? "null" : String.valueOf(this.request.getUserName()));
            url = url.replace("{clientId}", this.request.getClientId() == null || this.request.getClientId().length() == 0 ? "null" : String.valueOf(this.request.getClientId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateIdentifierTask
    extends Gs2RestSessionTask<CreateIdentifierResult> {
        private CreateIdentifierRequest request;

        public CreateIdentifierTask(CreateIdentifierRequest request, AsyncAction<AsyncResult<CreateIdentifierResult>> userCallback) {
            super((Gs2RestSession)Gs2IdentifierRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateIdentifierResult parse(JsonNode data) {
            return CreateIdentifierResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "identifier").replace("{region}", Gs2IdentifierRestClient.this.session.getRegion().getName()) + "/user/{userName}/identifier";
            url = url.replace("{userName}", this.request.getUserName() == null || this.request.getUserName().length() == 0 ? "null" : String.valueOf(this.request.getUserName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", CreateIdentifierTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeIdentifiersTask
    extends Gs2RestSessionTask<DescribeIdentifiersResult> {
        private DescribeIdentifiersRequest request;

        public DescribeIdentifiersTask(DescribeIdentifiersRequest request, AsyncAction<AsyncResult<DescribeIdentifiersResult>> userCallback) {
            super((Gs2RestSession)Gs2IdentifierRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeIdentifiersResult parse(JsonNode data) {
            return DescribeIdentifiersResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "identifier").replace("{region}", Gs2IdentifierRestClient.this.session.getRegion().getName()) + "/user/{userName}/identifier";
            url = url.replace("{userName}", this.request.getUserName() == null || this.request.getUserName().length() == 0 ? "null" : String.valueOf(this.request.getUserName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteSecurityPolicyTask
    extends Gs2RestSessionTask<DeleteSecurityPolicyResult> {
        private DeleteSecurityPolicyRequest request;

        public DeleteSecurityPolicyTask(DeleteSecurityPolicyRequest request, AsyncAction<AsyncResult<DeleteSecurityPolicyResult>> userCallback) {
            super((Gs2RestSession)Gs2IdentifierRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteSecurityPolicyResult parse(JsonNode data) {
            return DeleteSecurityPolicyResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "identifier").replace("{region}", Gs2IdentifierRestClient.this.session.getRegion().getName()) + "/securityPolicy/{securityPolicyName}";
            url = url.replace("{securityPolicyName}", this.request.getSecurityPolicyName() == null || this.request.getSecurityPolicyName().length() == 0 ? "null" : String.valueOf(this.request.getSecurityPolicyName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetSecurityPolicyTask
    extends Gs2RestSessionTask<GetSecurityPolicyResult> {
        private GetSecurityPolicyRequest request;

        public GetSecurityPolicyTask(GetSecurityPolicyRequest request, AsyncAction<AsyncResult<GetSecurityPolicyResult>> userCallback) {
            super((Gs2RestSession)Gs2IdentifierRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetSecurityPolicyResult parse(JsonNode data) {
            return GetSecurityPolicyResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "identifier").replace("{region}", Gs2IdentifierRestClient.this.session.getRegion().getName()) + "/securityPolicy/{securityPolicyName}";
            url = url.replace("{securityPolicyName}", this.request.getSecurityPolicyName() == null || this.request.getSecurityPolicyName().length() == 0 ? "null" : String.valueOf(this.request.getSecurityPolicyName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateSecurityPolicyTask
    extends Gs2RestSessionTask<UpdateSecurityPolicyResult> {
        private UpdateSecurityPolicyRequest request;

        public UpdateSecurityPolicyTask(UpdateSecurityPolicyRequest request, AsyncAction<AsyncResult<UpdateSecurityPolicyResult>> userCallback) {
            super((Gs2RestSession)Gs2IdentifierRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateSecurityPolicyResult parse(JsonNode data) {
            return UpdateSecurityPolicyResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "identifier").replace("{region}", Gs2IdentifierRestClient.this.session.getRegion().getName()) + "/securityPolicy/{securityPolicyName}";
            url = url.replace("{securityPolicyName}", this.request.getSecurityPolicyName() == null || this.request.getSecurityPolicyName().length() == 0 ? "null" : String.valueOf(this.request.getSecurityPolicyName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateSecurityPolicyTask.this.request.getDescription());
                    this.put("policy", UpdateSecurityPolicyTask.this.request.getPolicy());
                    this.put("contextStack", UpdateSecurityPolicyTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateSecurityPolicyTask
    extends Gs2RestSessionTask<CreateSecurityPolicyResult> {
        private CreateSecurityPolicyRequest request;

        public CreateSecurityPolicyTask(CreateSecurityPolicyRequest request, AsyncAction<AsyncResult<CreateSecurityPolicyResult>> userCallback) {
            super((Gs2RestSession)Gs2IdentifierRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateSecurityPolicyResult parse(JsonNode data) {
            return CreateSecurityPolicyResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "identifier").replace("{region}", Gs2IdentifierRestClient.this.session.getRegion().getName()) + "/securityPolicy";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateSecurityPolicyTask.this.request.getName());
                    this.put("description", CreateSecurityPolicyTask.this.request.getDescription());
                    this.put("policy", CreateSecurityPolicyTask.this.request.getPolicy());
                    this.put("contextStack", CreateSecurityPolicyTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeCommonSecurityPoliciesTask
    extends Gs2RestSessionTask<DescribeCommonSecurityPoliciesResult> {
        private DescribeCommonSecurityPoliciesRequest request;

        public DescribeCommonSecurityPoliciesTask(DescribeCommonSecurityPoliciesRequest request, AsyncAction<AsyncResult<DescribeCommonSecurityPoliciesResult>> userCallback) {
            super((Gs2RestSession)Gs2IdentifierRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeCommonSecurityPoliciesResult parse(JsonNode data) {
            return DescribeCommonSecurityPoliciesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "identifier").replace("{region}", Gs2IdentifierRestClient.this.session.getRegion().getName()) + "/securityPolicy/common";
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeSecurityPoliciesTask
    extends Gs2RestSessionTask<DescribeSecurityPoliciesResult> {
        private DescribeSecurityPoliciesRequest request;

        public DescribeSecurityPoliciesTask(DescribeSecurityPoliciesRequest request, AsyncAction<AsyncResult<DescribeSecurityPoliciesResult>> userCallback) {
            super((Gs2RestSession)Gs2IdentifierRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeSecurityPoliciesResult parse(JsonNode data) {
            return DescribeSecurityPoliciesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "identifier").replace("{region}", Gs2IdentifierRestClient.this.session.getRegion().getName()) + "/securityPolicy";
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteUserTask
    extends Gs2RestSessionTask<DeleteUserResult> {
        private DeleteUserRequest request;

        public DeleteUserTask(DeleteUserRequest request, AsyncAction<AsyncResult<DeleteUserResult>> userCallback) {
            super((Gs2RestSession)Gs2IdentifierRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteUserResult parse(JsonNode data) {
            return DeleteUserResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "identifier").replace("{region}", Gs2IdentifierRestClient.this.session.getRegion().getName()) + "/user/{userName}";
            url = url.replace("{userName}", this.request.getUserName() == null || this.request.getUserName().length() == 0 ? "null" : String.valueOf(this.request.getUserName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetUserTask
    extends Gs2RestSessionTask<GetUserResult> {
        private GetUserRequest request;

        public GetUserTask(GetUserRequest request, AsyncAction<AsyncResult<GetUserResult>> userCallback) {
            super((Gs2RestSession)Gs2IdentifierRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetUserResult parse(JsonNode data) {
            return GetUserResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "identifier").replace("{region}", Gs2IdentifierRestClient.this.session.getRegion().getName()) + "/user/{userName}";
            url = url.replace("{userName}", this.request.getUserName() == null || this.request.getUserName().length() == 0 ? "null" : String.valueOf(this.request.getUserName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateUserTask
    extends Gs2RestSessionTask<UpdateUserResult> {
        private UpdateUserRequest request;

        public UpdateUserTask(UpdateUserRequest request, AsyncAction<AsyncResult<UpdateUserResult>> userCallback) {
            super((Gs2RestSession)Gs2IdentifierRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateUserResult parse(JsonNode data) {
            return UpdateUserResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "identifier").replace("{region}", Gs2IdentifierRestClient.this.session.getRegion().getName()) + "/user/{userName}";
            url = url.replace("{userName}", this.request.getUserName() == null || this.request.getUserName().length() == 0 ? "null" : String.valueOf(this.request.getUserName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateUserTask.this.request.getDescription());
                    this.put("contextStack", UpdateUserTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateUserTask
    extends Gs2RestSessionTask<CreateUserResult> {
        private CreateUserRequest request;

        public CreateUserTask(CreateUserRequest request, AsyncAction<AsyncResult<CreateUserResult>> userCallback) {
            super((Gs2RestSession)Gs2IdentifierRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateUserResult parse(JsonNode data) {
            return CreateUserResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "identifier").replace("{region}", Gs2IdentifierRestClient.this.session.getRegion().getName()) + "/user";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateUserTask.this.request.getName());
                    this.put("description", CreateUserTask.this.request.getDescription());
                    this.put("contextStack", CreateUserTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeUsersTask
    extends Gs2RestSessionTask<DescribeUsersResult> {
        private DescribeUsersRequest request;

        public DescribeUsersTask(DescribeUsersRequest request, AsyncAction<AsyncResult<DescribeUsersResult>> userCallback) {
            super((Gs2RestSession)Gs2IdentifierRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeUsersResult parse(JsonNode data) {
            return DescribeUsersResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "identifier").replace("{region}", Gs2IdentifierRestClient.this.session.getRegion().getName()) + "/user";
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }
}

