/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.gateway.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.core.net.Gs2WebSocketSession;
import io.gs2.gateway.Gs2GatewayRestClient;
import io.gs2.gateway.Gs2GatewayWebSocketClient;
import io.gs2.gateway.domain.model.UserDomain;
import io.gs2.gateway.model.WebSocketSession;
import io.gs2.gateway.request.SetUserIdByUserIdRequest;
import io.gs2.gateway.result.SetUserIdByUserIdResult;

public class WebSocketSessionDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2GatewayRestClient client;
    private final Gs2WebSocketSession wssession;
    private final Gs2GatewayWebSocketClient wsclient;
    private final String namespaceName;
    private final String userId;
    private final String connectionId;
    private final String parentKey;
    String protocol;

    public String getProtocol() {
        return this.protocol;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public WebSocketSessionDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, Gs2WebSocketSession wssession, String namespaceName, String userId, String connectionId) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2GatewayRestClient(session);
        this.wssession = wssession;
        this.wsclient = new Gs2GatewayWebSocketClient(wssession);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.connectionId = connectionId;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "WebSocketSession");
    }

    public WebSocketSessionDomain setUserId(SetUserIdByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId);
        SetUserIdByUserIdResult result = this.client.setUserIdByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, WebSocketSessionDomain.createCacheKey(), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        WebSocketSessionDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String childType) {
        return String.join((CharSequence)":", "gateway", namespaceName, userId, childType);
    }

    public static String createCacheKey() {
        return "Singleton";
    }

    public WebSocketSession model() {
        WebSocketSession value = this.cache.get(this.parentKey, WebSocketSessionDomain.createCacheKey(), WebSocketSession.class);
        return value;
    }
}

