/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.gateway.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.core.net.Gs2WebSocketSession;
import io.gs2.gateway.Gs2GatewayRestClient;
import io.gs2.gateway.Gs2GatewayWebSocketClient;
import io.gs2.gateway.domain.iterator.DescribeWebSocketSessionsIterator;
import io.gs2.gateway.domain.model.FirebaseTokenAccessTokenDomain;
import io.gs2.gateway.domain.model.NamespaceDomain;
import io.gs2.gateway.domain.model.WebSocketSessionAccessTokenDomain;

public class UserAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2GatewayRestClient client;
    private final Gs2WebSocketSession wssession;
    private final Gs2GatewayWebSocketClient wsclient;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final String parentKey;
    String protocol;
    String nextPageToken;

    public String getProtocol() {
        return this.protocol;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public UserAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, Gs2WebSocketSession wssession, String namespaceName, AccessToken accessToken) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2GatewayRestClient(session);
        this.wssession = wssession;
        this.wsclient = new Gs2GatewayWebSocketClient(wssession);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "User");
    }

    public DescribeWebSocketSessionsIterator webSocketSessions() {
        return new DescribeWebSocketSessionsIterator(this.cache, this.client, this.namespaceName, this.accessToken);
    }

    public WebSocketSessionAccessTokenDomain webSocketSession(String connectionId) {
        return new WebSocketSessionAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.wssession, this.namespaceName, this.accessToken, connectionId);
    }

    public FirebaseTokenAccessTokenDomain firebaseToken() {
        return new FirebaseTokenAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.wssession, this.namespaceName, this.accessToken);
    }

    public static String createCacheParentKey(String namespaceName, String userId, String childType) {
        return String.join((CharSequence)":", "gateway", namespaceName, userId, childType);
    }

    public static String createCacheKey(String userId) {
        return String.join((CharSequence)":", userId);
    }
}

