/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.friend.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.friend.Gs2FriendRestClient;
import io.gs2.friend.domain.iterator.DescribeBlackListByUserIdIterator;
import io.gs2.friend.domain.iterator.DescribeFollowsByUserIdIterator;
import io.gs2.friend.domain.iterator.DescribeFriendsByUserIdIterator;
import io.gs2.friend.domain.iterator.DescribeReceiveRequestsByUserIdIterator;
import io.gs2.friend.domain.iterator.DescribeSendRequestsByUserIdIterator;
import io.gs2.friend.domain.model.BlackListDomain;
import io.gs2.friend.domain.model.FollowDomain;
import io.gs2.friend.domain.model.FriendDomain;
import io.gs2.friend.domain.model.FriendRequestDomain;
import io.gs2.friend.domain.model.InboxDomain;
import io.gs2.friend.domain.model.NamespaceDomain;
import io.gs2.friend.domain.model.ProfileDomain;
import io.gs2.friend.domain.model.PublicProfileDomain;
import io.gs2.friend.domain.model.ReceiveFriendRequestDomain;
import io.gs2.friend.domain.model.SendBoxDomain;
import io.gs2.friend.domain.model.SendFriendRequestDomain;
import io.gs2.friend.request.SendRequestByUserIdRequest;
import io.gs2.friend.result.SendRequestByUserIdResult;

public class UserDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2FriendRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String parentKey;
    String nextPageToken;

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public UserDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2FriendRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "User");
    }

    public FriendRequestDomain sendRequest(SendRequestByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId);
        SendRequestByUserIdResult result = this.client.sendRequestByUserId(request);
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "FriendRequest");
        if (result.getItem() != null) {
            this.cache.put(parentKey, FriendRequestDomain.createCacheKey(request.getTargetUserId() != null ? request.getTargetUserId().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        FriendRequestDomain domain = new FriendRequestDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), result.getItem().getUserId(), result.getItem().getTargetUserId());
        return domain;
    }

    public ProfileDomain profile() {
        return new ProfileDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.userId);
    }

    public PublicProfileDomain publicProfile() {
        return new PublicProfileDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.userId);
    }

    public DescribeBlackListByUserIdIterator blackLists() {
        return new DescribeBlackListByUserIdIterator(this.cache, this.client, this.namespaceName, this.userId);
    }

    public BlackListDomain blackList() {
        return new BlackListDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.userId);
    }

    public DescribeFollowsByUserIdIterator follows(Boolean withProfile) {
        return new DescribeFollowsByUserIdIterator(this.cache, this.client, this.namespaceName, this.userId, withProfile);
    }

    public FollowDomain follow(Boolean withProfile) {
        return new FollowDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.userId, withProfile);
    }

    public DescribeFriendsByUserIdIterator friends(Boolean withProfile) {
        return new DescribeFriendsByUserIdIterator(this.cache, this.client, this.namespaceName, this.userId, withProfile);
    }

    public FriendDomain friend(Boolean withProfile) {
        return new FriendDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.userId, withProfile);
    }

    public SendBoxDomain sendBox() {
        return new SendBoxDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.userId);
    }

    public FriendRequestDomain friendRequest(String targetUserId) {
        return new FriendRequestDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.userId, targetUserId);
    }

    public DescribeSendRequestsByUserIdIterator sendRequests() {
        return new DescribeSendRequestsByUserIdIterator(this.cache, this.client, this.namespaceName, this.userId);
    }

    public SendFriendRequestDomain sendFriendRequest(String targetUserId) {
        return new SendFriendRequestDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.userId, targetUserId);
    }

    public InboxDomain inbox() {
        return new InboxDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.userId);
    }

    public DescribeReceiveRequestsByUserIdIterator receiveRequests() {
        return new DescribeReceiveRequestsByUserIdIterator(this.cache, this.client, this.namespaceName, this.userId);
    }

    public ReceiveFriendRequestDomain receiveFriendRequest(String fromUserId) {
        return new ReceiveFriendRequestDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.userId, fromUserId);
    }

    public static String createCacheParentKey(String namespaceName, String userId, String childType) {
        return String.join((CharSequence)":", "friend", namespaceName, userId, childType);
    }

    public static String createCacheKey(String userId) {
        return String.join((CharSequence)":", userId);
    }
}

