/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.friend.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.friend.Gs2FriendRestClient;
import io.gs2.friend.domain.model.FriendRequestAccessTokenDomain;
import io.gs2.friend.domain.model.FriendRequestDomain;
import io.gs2.friend.domain.model.SendFriendRequestDomain;
import io.gs2.friend.domain.model.UserDomain;
import io.gs2.friend.model.FriendRequest;
import io.gs2.friend.model.SendFriendRequest;
import io.gs2.friend.request.DeleteRequestRequest;
import io.gs2.friend.request.GetSendRequestRequest;
import io.gs2.friend.result.DeleteRequestResult;
import io.gs2.friend.result.GetSendRequestResult;

public class SendFriendRequestAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2FriendRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final String targetUserId;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public String getTargetUserId() {
        return this.targetUserId;
    }

    public SendFriendRequestAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken, String targetUserId) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2FriendRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.targetUserId = targetUserId;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "SendFriendRequest");
    }

    private FriendRequest get(GetSendRequestRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withTargetUserId(this.targetUserId);
        GetSendRequestResult result = this.client.getSendRequest(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, FriendRequestDomain.createCacheKey(request.getTargetUserId() != null ? request.getTargetUserId().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public FriendRequestAccessTokenDomain delete(DeleteRequestRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withTargetUserId(this.targetUserId);
        DeleteRequestResult result = null;
        try {
            result = this.client.deleteRequest(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, FriendRequestDomain.createCacheKey(request.getTargetUserId() != null ? request.getTargetUserId().toString() : null), FriendRequest.class);
        FriendRequestAccessTokenDomain domain = new FriendRequestAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), this.accessToken, result.getItem().getTargetUserId());
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String targetUserId, String childType) {
        return String.join((CharSequence)":", "friend", namespaceName, userId, targetUserId, childType);
    }

    public static String createCacheKey(String targetUserId) {
        return String.join((CharSequence)":", targetUserId);
    }

    public FriendRequest model() {
        FriendRequest value = this.cache.get(this.parentKey, SendFriendRequestDomain.createCacheKey(this.getTargetUserId() != null ? this.getTargetUserId().toString() : null), FriendRequest.class);
        if (value == null) {
            try {
                this.get(new GetSendRequestRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, SendFriendRequestDomain.createCacheKey(this.getTargetUserId() != null ? this.getTargetUserId().toString() : null), SendFriendRequest.class);
            }
            value = this.cache.get(this.parentKey, SendFriendRequestDomain.createCacheKey(this.getTargetUserId() != null ? this.getTargetUserId().toString() : null), FriendRequest.class);
        }
        return value;
    }
}

