/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.friend.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.friend.Gs2FriendRestClient;
import io.gs2.friend.domain.model.ProfileDomain;
import io.gs2.friend.domain.model.UserDomain;
import io.gs2.friend.model.Profile;
import io.gs2.friend.request.GetProfileRequest;
import io.gs2.friend.request.UpdateProfileRequest;
import io.gs2.friend.result.GetProfileResult;
import io.gs2.friend.result.UpdateProfileResult;

public class ProfileAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2FriendRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public ProfileAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2FriendRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "Profile");
    }

    private Profile get(GetProfileRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null);
        GetProfileResult result = this.client.getProfile(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, ProfileDomain.createCacheKey(), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public ProfileAccessTokenDomain update(UpdateProfileRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null);
        UpdateProfileResult result = this.client.updateProfile(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, ProfileDomain.createCacheKey(), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        ProfileAccessTokenDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String childType) {
        return String.join((CharSequence)":", "friend", namespaceName, userId, childType);
    }

    public static String createCacheKey() {
        return "Singleton";
    }

    public Profile model() {
        Profile value = this.cache.get(this.parentKey, ProfileDomain.createCacheKey(), Profile.class);
        if (value == null) {
            try {
                this.get(new GetProfileRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, ProfileDomain.createCacheKey(), Profile.class);
            }
            value = this.cache.get(this.parentKey, ProfileDomain.createCacheKey(), Profile.class);
        }
        return value;
    }
}

