/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.friend.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.friend.Gs2FriendRestClient;
import io.gs2.friend.domain.model.FriendDomain;
import io.gs2.friend.domain.model.FriendUserDomain;
import io.gs2.friend.model.FriendUser;
import io.gs2.friend.request.DeleteFriendRequest;
import io.gs2.friend.request.GetFriendRequest;
import io.gs2.friend.result.DeleteFriendResult;
import io.gs2.friend.result.GetFriendResult;

public class FriendUserAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2FriendRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final Boolean withProfile;
    private final String targetUserId;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public Boolean getWithProfile() {
        return this.withProfile;
    }

    public String getTargetUserId() {
        return this.targetUserId;
    }

    public FriendUserAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken, Boolean withProfile, String targetUserId) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2FriendRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.withProfile = withProfile;
        this.targetUserId = targetUserId;
        this.parentKey = FriendDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, this.withProfile != null ? this.withProfile.toString() : "false", "FriendUser");
    }

    private FriendUser get(GetFriendRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withWithProfile(this.withProfile).withTargetUserId(this.targetUserId);
        GetFriendResult result = this.client.getFriend(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, FriendUserDomain.createCacheKey(request.getTargetUserId() != null ? request.getTargetUserId().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public FriendUserAccessTokenDomain delete(DeleteFriendRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withTargetUserId(this.targetUserId);
        DeleteFriendResult result = null;
        try {
            result = this.client.deleteFriend(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, FriendUserDomain.createCacheKey(request.getTargetUserId() != null ? request.getTargetUserId().toString() : null), FriendUser.class);
        this.cache.delete(FriendDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.getTargetUserId() != null ? this.getTargetUserId().toString() : null, this.withProfile != null ? this.withProfile.toString() : "false", "FriendUser"), FriendUserDomain.createCacheKey(this.getUserId() != null ? this.getUserId().toString() : null), FriendUser.class);
        FriendUserAccessTokenDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String withProfile, String targetUserId, String childType) {
        return String.join((CharSequence)":", "friend", namespaceName, userId, withProfile, targetUserId, childType);
    }

    public static String createCacheKey(String targetUserId) {
        return String.join((CharSequence)":", targetUserId);
    }

    public FriendUser model() {
        FriendUser value = this.cache.get(this.parentKey, FriendUserDomain.createCacheKey(this.getTargetUserId() != null ? this.getTargetUserId().toString() : null), FriendUser.class);
        if (value == null) {
            try {
                this.get(new GetFriendRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, FriendUserDomain.createCacheKey(this.getTargetUserId() != null ? this.getTargetUserId().toString() : null), FriendUser.class);
            }
            value = this.cache.get(this.parentKey, FriendUserDomain.createCacheKey(this.getTargetUserId() != null ? this.getTargetUserId().toString() : null), FriendUser.class);
        }
        return value;
    }
}

