/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.friend.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.friend.Gs2FriendRestClient;
import io.gs2.friend.domain.model.FollowUserDomain;
import io.gs2.friend.domain.model.UserDomain;
import io.gs2.friend.model.Follow;
import io.gs2.friend.request.FollowByUserIdRequest;
import io.gs2.friend.result.FollowByUserIdResult;

public class FollowDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2FriendRestClient client;
    private final String namespaceName;
    private final String userId;
    private final Boolean withProfile;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public Boolean getWithProfile() {
        return this.withProfile;
    }

    public FollowDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId, Boolean withProfile) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2FriendRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.withProfile = withProfile;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Follow");
    }

    public FollowUserDomain follow(FollowByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId);
        FollowByUserIdResult result = this.client.followByUserId(request);
        String parentKey = FollowDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, this.withProfile != null ? this.withProfile.toString() : "false", "FollowUser");
        if (result.getItem() != null) {
            this.cache.put(parentKey, FollowUserDomain.createCacheKey(request.getTargetUserId() != null ? request.getTargetUserId().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        FollowUserDomain domain = new FollowUserDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), result.getItem().getUserId(), this.withProfile, request.getTargetUserId());
        return domain;
    }

    public FollowUserDomain followUser(String targetUserId) {
        return new FollowUserDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.userId, this.withProfile, targetUserId);
    }

    public static String createCacheParentKey(String namespaceName, String userId, String withProfile, String childType) {
        return String.join((CharSequence)":", "friend", namespaceName, userId, withProfile, childType);
    }

    public static String createCacheKey(String withProfile) {
        return String.join((CharSequence)":", withProfile);
    }

    public Follow model() {
        Follow value = this.cache.get(this.parentKey, FollowDomain.createCacheKey(this.getWithProfile() != null ? this.getWithProfile().toString() : null), Follow.class);
        return value;
    }
}

