/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.friend.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.friend.Gs2FriendRestClient;
import io.gs2.friend.domain.model.FollowDomain;
import io.gs2.friend.domain.model.FollowUserAccessTokenDomain;
import io.gs2.friend.domain.model.FollowUserDomain;
import io.gs2.friend.domain.model.UserDomain;
import io.gs2.friend.model.Follow;
import io.gs2.friend.request.FollowRequest;
import io.gs2.friend.result.FollowResult;

public class FollowAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2FriendRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final Boolean withProfile;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public Boolean getWithProfile() {
        return this.withProfile;
    }

    public FollowAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken, Boolean withProfile) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2FriendRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.withProfile = withProfile;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "Follow");
    }

    public FollowUserAccessTokenDomain follow(FollowRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null);
        FollowResult result = this.client.follow(request);
        String parentKey = FollowDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, this.withProfile != null ? this.withProfile.toString() : "false", "FollowUser");
        if (result.getItem() != null) {
            this.cache.put(parentKey, FollowUserDomain.createCacheKey(request.getTargetUserId() != null ? request.getTargetUserId().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        FollowUserAccessTokenDomain domain = new FollowUserAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), this.accessToken, this.withProfile, request.getTargetUserId());
        return domain;
    }

    public FollowUserAccessTokenDomain followUser(String targetUserId) {
        return new FollowUserAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.accessToken, this.withProfile, targetUserId);
    }

    public static String createCacheParentKey(String namespaceName, String userId, String withProfile, String childType) {
        return String.join((CharSequence)":", "friend", namespaceName, userId, withProfile, childType);
    }

    public static String createCacheKey(String withProfile) {
        return String.join((CharSequence)":", withProfile);
    }

    public Follow model() {
        Follow value = this.cache.get(this.parentKey, FollowDomain.createCacheKey(this.getWithProfile() != null ? this.getWithProfile().toString() : null), Follow.class);
        return value;
    }
}

