/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.friend.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.friend.Gs2FriendRestClient;
import io.gs2.friend.domain.model.FriendDomain;
import io.gs2.friend.domain.model.FriendUserDomain;
import io.gs2.friend.model.FriendUser;
import io.gs2.friend.request.DescribeFriendsByUserIdRequest;
import io.gs2.friend.result.DescribeFriendsByUserIdResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeFriendsByUserIdIterator
implements Iterator<FriendUser>,
Iterable<FriendUser> {
    CacheDatabase cache;
    Gs2FriendRestClient client;
    String namespaceName;
    String userId;
    Boolean withProfile;
    String pageToken;
    boolean last;
    List<FriendUser> result;
    Integer fetchSize;

    public DescribeFriendsByUserIdIterator(CacheDatabase cache, Gs2FriendRestClient client, String namespaceName, String userId, Boolean withProfile) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.withProfile = withProfile;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<FriendUser>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = FriendDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, this.withProfile != null ? this.withProfile.toString() : "false", "FriendUser");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, FriendUser.class)) {
            this.result = this.cache.list(parentKey, FriendUser.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeFriendsByUserIdResult r = this.client.describeFriendsByUserId(new DescribeFriendsByUserIdRequest().withNamespaceName(this.namespaceName).withUserId(this.userId).withWithProfile(this.withProfile).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (FriendUser item : this.result) {
                this.cache.put(parentKey, FriendUserDomain.createCacheKey(item.getUserId() != null ? item.getUserId().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, FriendUser.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public FriendUser next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        FriendUser ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<FriendUser> iterator() {
        return this;
    }
}

