/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.friend.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.friend.Gs2FriendRestClient;
import io.gs2.friend.request.DescribeBlackListByUserIdRequest;
import io.gs2.friend.result.DescribeBlackListByUserIdResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeBlackListByUserIdIterator
implements Iterator<String>,
Iterable<String> {
    CacheDatabase cache;
    Gs2FriendRestClient client;
    String namespaceName;
    String userId;
    String pageToken;
    boolean last;
    List<String> result;
    Integer fetchSize;

    public DescribeBlackListByUserIdIterator(CacheDatabase cache, Gs2FriendRestClient client, String namespaceName, String userId) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<String>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = "friend:String";
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, String.class)) {
            this.result = this.cache.list(parentKey, String.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeBlackListByUserIdResult r = this.client.describeBlackListByUserId(new DescribeBlackListByUserIdRequest().withNamespaceName(this.namespaceName).withUserId(this.userId).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (String item : this.result) {
                this.cache.put(parentKey, item, item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, String.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public String next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        String ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }
}

