/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.formation.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.formation.Gs2FormationRestClient;
import io.gs2.formation.domain.iterator.DescribeFormModelMastersIterator;
import io.gs2.formation.domain.iterator.DescribeMoldModelMastersIterator;
import io.gs2.formation.domain.iterator.DescribeMoldModelsIterator;
import io.gs2.formation.domain.model.CurrentFormMasterDomain;
import io.gs2.formation.domain.model.FormModelMasterDomain;
import io.gs2.formation.domain.model.MoldModelDomain;
import io.gs2.formation.domain.model.MoldModelMasterDomain;
import io.gs2.formation.domain.model.UserAccessTokenDomain;
import io.gs2.formation.domain.model.UserDomain;
import io.gs2.formation.model.Namespace;
import io.gs2.formation.request.CreateFormModelMasterRequest;
import io.gs2.formation.request.CreateMoldModelMasterRequest;
import io.gs2.formation.request.DeleteNamespaceRequest;
import io.gs2.formation.request.GetNamespaceRequest;
import io.gs2.formation.request.GetNamespaceStatusRequest;
import io.gs2.formation.request.UpdateNamespaceRequest;
import io.gs2.formation.result.CreateFormModelMasterResult;
import io.gs2.formation.result.CreateMoldModelMasterResult;
import io.gs2.formation.result.DeleteNamespaceResult;
import io.gs2.formation.result.GetNamespaceResult;
import io.gs2.formation.result.GetNamespaceStatusResult;
import io.gs2.formation.result.UpdateNamespaceResult;

public class NamespaceDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2FormationRestClient client;
    private final String namespaceName;
    private final String parentKey;
    String status;
    String nextPageToken;

    public String getStatus() {
        return this.status;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public NamespaceDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2FormationRestClient(session);
        this.namespaceName = namespaceName;
        this.parentKey = "formation:Namespace";
    }

    public NamespaceDomain getStatus(GetNamespaceStatusRequest request) {
        request.withNamespaceName(this.namespaceName);
        GetNamespaceStatusResult result = this.client.getNamespaceStatus(request);
        NamespaceDomain domain = this;
        this.status = result.getStatus();
        return domain;
    }

    private Namespace get(GetNamespaceRequest request) {
        request.withNamespaceName(this.namespaceName);
        GetNamespaceResult result = this.client.getNamespace(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, NamespaceDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public NamespaceDomain update(UpdateNamespaceRequest request) {
        request.withNamespaceName(this.namespaceName);
        UpdateNamespaceResult result = this.client.updateNamespace(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, NamespaceDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        NamespaceDomain domain = this;
        return domain;
    }

    public NamespaceDomain delete(DeleteNamespaceRequest request) {
        request.withNamespaceName(this.namespaceName);
        DeleteNamespaceResult result = null;
        try {
            result = this.client.deleteNamespace(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, NamespaceDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), Namespace.class);
        NamespaceDomain domain = this;
        return domain;
    }

    public FormModelMasterDomain createFormModelMaster(CreateFormModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        CreateFormModelMasterResult result = this.client.createFormModelMaster(request);
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "FormModelMaster");
        if (result.getItem() != null) {
            this.cache.put(parentKey, FormModelMasterDomain.createCacheKey(result.getItem().getName() != null ? result.getItem().getName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        FormModelMasterDomain domain = new FormModelMasterDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), result.getItem().getName());
        return domain;
    }

    public MoldModelMasterDomain createMoldModelMaster(CreateMoldModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        CreateMoldModelMasterResult result = this.client.createMoldModelMaster(request);
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "MoldModelMaster");
        if (result.getItem() != null) {
            this.cache.put(parentKey, MoldModelMasterDomain.createCacheKey(result.getItem().getName() != null ? result.getItem().getName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        MoldModelMasterDomain domain = new MoldModelMasterDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), result.getItem().getName());
        return domain;
    }

    public CurrentFormMasterDomain currentFormMaster() {
        return new CurrentFormMasterDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName);
    }

    public DescribeMoldModelsIterator moldModels() {
        return new DescribeMoldModelsIterator(this.cache, this.client, this.namespaceName);
    }

    public MoldModelDomain moldModel(String moldName) {
        return new MoldModelDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, moldName);
    }

    public UserDomain user(String userId) {
        return new UserDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, userId);
    }

    public UserAccessTokenDomain accessToken(AccessToken accessToken) {
        return new UserAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, accessToken);
    }

    public DescribeFormModelMastersIterator formModelMasters() {
        return new DescribeFormModelMastersIterator(this.cache, this.client, this.namespaceName);
    }

    public FormModelMasterDomain formModelMaster(String formModelName) {
        return new FormModelMasterDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, formModelName);
    }

    public DescribeMoldModelMastersIterator moldModelMasters() {
        return new DescribeMoldModelMastersIterator(this.cache, this.client, this.namespaceName);
    }

    public MoldModelMasterDomain moldModelMaster(String moldName) {
        return new MoldModelMasterDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, moldName);
    }

    public static String createCacheParentKey(String namespaceName, String childType) {
        return String.join((CharSequence)":", "formation", namespaceName, childType);
    }

    public static String createCacheKey(String namespaceName) {
        return String.join((CharSequence)":", namespaceName);
    }

    public Namespace model() {
        Namespace value = this.cache.get(this.parentKey, NamespaceDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), Namespace.class);
        if (value == null) {
            try {
                this.get(new GetNamespaceRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, NamespaceDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), Namespace.class);
            }
            value = this.cache.get(this.parentKey, NamespaceDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), Namespace.class);
        }
        return value;
    }
}

