/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.formation.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.formation.Gs2FormationRestClient;
import io.gs2.formation.domain.iterator.DescribeFormsIterator;
import io.gs2.formation.domain.model.FormAccessTokenDomain;
import io.gs2.formation.domain.model.MoldDomain;
import io.gs2.formation.domain.model.MoldModelDomain;
import io.gs2.formation.domain.model.UserDomain;
import io.gs2.formation.model.Mold;
import io.gs2.formation.request.DeleteMoldRequest;
import io.gs2.formation.request.GetMoldRequest;
import io.gs2.formation.result.DeleteMoldResult;
import io.gs2.formation.result.GetMoldResult;

public class MoldAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2FormationRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final String moldName;
    private final String parentKey;
    String nextPageToken;

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public String getMoldName() {
        return this.moldName;
    }

    public MoldAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken, String moldName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2FormationRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.moldName = moldName;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "Mold");
    }

    private Mold get(GetMoldRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withMoldName(this.moldName);
        GetMoldResult result = this.client.getMold(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, MoldDomain.createCacheKey(request.getMoldName() != null ? request.getMoldName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        if (result.getMoldModel() != null) {
            this.cache.put(this.parentKey, MoldModelDomain.createCacheKey(request.getMoldName() != null ? request.getMoldName().toString() : null), result.getMoldModel(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public MoldAccessTokenDomain delete(DeleteMoldRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withMoldName(this.moldName);
        DeleteMoldResult result = null;
        try {
            result = this.client.deleteMold(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, MoldDomain.createCacheKey(request.getMoldName() != null ? request.getMoldName().toString() : null), Mold.class);
        MoldAccessTokenDomain domain = this;
        return domain;
    }

    public DescribeFormsIterator forms() {
        return new DescribeFormsIterator(this.cache, this.client, this.namespaceName, this.moldName, this.accessToken);
    }

    public FormAccessTokenDomain form(Integer index) {
        return new FormAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.accessToken, this.moldName, index);
    }

    public static String createCacheParentKey(String namespaceName, String userId, String moldName, String childType) {
        return String.join((CharSequence)":", "formation", namespaceName, userId, moldName, childType);
    }

    public static String createCacheKey(String moldName) {
        return String.join((CharSequence)":", moldName);
    }

    public Mold model() {
        Mold value = this.cache.get(this.parentKey, MoldDomain.createCacheKey(this.getMoldName() != null ? this.getMoldName().toString() : null), Mold.class);
        if (value == null) {
            try {
                this.get(new GetMoldRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, MoldDomain.createCacheKey(this.getMoldName() != null ? this.getMoldName().toString() : null), Mold.class);
            }
            value = this.cache.get(this.parentKey, MoldDomain.createCacheKey(this.getMoldName() != null ? this.getMoldName().toString() : null), Mold.class);
        }
        return value;
    }
}

