/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.formation.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.formation.Gs2FormationRestClient;
import io.gs2.formation.domain.model.MoldModelDomain;
import io.gs2.formation.domain.model.NamespaceDomain;
import io.gs2.formation.model.MoldModel;
import io.gs2.formation.request.DescribeMoldModelsRequest;
import io.gs2.formation.result.DescribeMoldModelsResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeMoldModelsIterator
implements Iterator<MoldModel>,
Iterable<MoldModel> {
    CacheDatabase cache;
    Gs2FormationRestClient client;
    String namespaceName;
    boolean last;
    List<MoldModel> result;
    Integer fetchSize;

    public DescribeMoldModelsIterator(CacheDatabase cache, Gs2FormationRestClient client, String namespaceName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.last = false;
        this.result = new ArrayList<MoldModel>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "MoldModel");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, MoldModel.class)) {
            this.result = this.cache.list(parentKey, MoldModel.class).stream().collect(Collectors.toList());
            this.last = true;
        } else {
            DescribeMoldModelsResult r = this.client.describeMoldModels(new DescribeMoldModelsRequest().withNamespaceName(this.namespaceName));
            this.result = r.getItems();
            this.last = true;
            for (MoldModel item : this.result) {
                this.cache.put(parentKey, MoldModelDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, MoldModel.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public MoldModel next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        MoldModel ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<MoldModel> iterator() {
        return this;
    }
}

