/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.formation.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.formation.Gs2FormationRestClient;
import io.gs2.formation.domain.model.MoldModelMasterDomain;
import io.gs2.formation.domain.model.NamespaceDomain;
import io.gs2.formation.model.MoldModelMaster;
import io.gs2.formation.request.DescribeMoldModelMastersRequest;
import io.gs2.formation.result.DescribeMoldModelMastersResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeMoldModelMastersIterator
implements Iterator<MoldModelMaster>,
Iterable<MoldModelMaster> {
    CacheDatabase cache;
    Gs2FormationRestClient client;
    String namespaceName;
    String pageToken;
    boolean last;
    List<MoldModelMaster> result;
    Integer fetchSize;

    public DescribeMoldModelMastersIterator(CacheDatabase cache, Gs2FormationRestClient client, String namespaceName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<MoldModelMaster>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "MoldModelMaster");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, MoldModelMaster.class)) {
            this.result = this.cache.list(parentKey, MoldModelMaster.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeMoldModelMastersResult r = this.client.describeMoldModelMasters(new DescribeMoldModelMastersRequest().withNamespaceName(this.namespaceName).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (MoldModelMaster item : this.result) {
                this.cache.put(parentKey, MoldModelMasterDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, MoldModelMaster.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public MoldModelMaster next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        MoldModelMaster ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<MoldModelMaster> iterator() {
        return this;
    }
}

