/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.formation.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.formation.Gs2FormationRestClient;
import io.gs2.formation.domain.model.FormDomain;
import io.gs2.formation.domain.model.MoldDomain;
import io.gs2.formation.model.Form;
import io.gs2.formation.request.DescribeFormsByUserIdRequest;
import io.gs2.formation.result.DescribeFormsByUserIdResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeFormsByUserIdIterator
implements Iterator<Form>,
Iterable<Form> {
    CacheDatabase cache;
    Gs2FormationRestClient client;
    String namespaceName;
    String moldName;
    String userId;
    String pageToken;
    boolean last;
    List<Form> result;
    Integer fetchSize;

    public DescribeFormsByUserIdIterator(CacheDatabase cache, Gs2FormationRestClient client, String namespaceName, String moldName, String userId) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.moldName = moldName;
        this.userId = userId;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<Form>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = MoldDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, this.moldName != null ? this.moldName.toString() : null, "Form");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, Form.class)) {
            this.result = this.cache.list(parentKey, Form.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeFormsByUserIdResult r = this.client.describeFormsByUserId(new DescribeFormsByUserIdRequest().withNamespaceName(this.namespaceName).withMoldName(this.moldName).withUserId(this.userId).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (Form item : this.result) {
                this.cache.put(parentKey, FormDomain.createCacheKey(item.getIndex() != null ? item.getIndex().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, Form.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public Form next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        Form ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<Form> iterator() {
        return this;
    }
}

