/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.experience.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.experience.Gs2ExperienceRestClient;
import io.gs2.experience.domain.iterator.DescribeExperienceModelMastersIterator;
import io.gs2.experience.domain.iterator.DescribeExperienceModelsIterator;
import io.gs2.experience.domain.iterator.DescribeThresholdMastersIterator;
import io.gs2.experience.domain.model.CurrentExperienceMasterDomain;
import io.gs2.experience.domain.model.ExperienceModelDomain;
import io.gs2.experience.domain.model.ExperienceModelMasterDomain;
import io.gs2.experience.domain.model.ThresholdMasterDomain;
import io.gs2.experience.domain.model.UserAccessTokenDomain;
import io.gs2.experience.domain.model.UserDomain;
import io.gs2.experience.model.Namespace;
import io.gs2.experience.request.CreateExperienceModelMasterRequest;
import io.gs2.experience.request.CreateThresholdMasterRequest;
import io.gs2.experience.request.DeleteNamespaceRequest;
import io.gs2.experience.request.GetNamespaceRequest;
import io.gs2.experience.request.GetNamespaceStatusRequest;
import io.gs2.experience.request.UpdateNamespaceRequest;
import io.gs2.experience.result.CreateExperienceModelMasterResult;
import io.gs2.experience.result.CreateThresholdMasterResult;
import io.gs2.experience.result.DeleteNamespaceResult;
import io.gs2.experience.result.GetNamespaceResult;
import io.gs2.experience.result.GetNamespaceStatusResult;
import io.gs2.experience.result.UpdateNamespaceResult;

public class NamespaceDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2ExperienceRestClient client;
    private final String namespaceName;
    private final String parentKey;
    String status;
    String nextPageToken;

    public String getStatus() {
        return this.status;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public NamespaceDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2ExperienceRestClient(session);
        this.namespaceName = namespaceName;
        this.parentKey = "experience:Namespace";
    }

    public NamespaceDomain getStatus(GetNamespaceStatusRequest request) {
        request.withNamespaceName(this.namespaceName);
        GetNamespaceStatusResult result = this.client.getNamespaceStatus(request);
        NamespaceDomain domain = this;
        this.status = result.getStatus();
        return domain;
    }

    private Namespace get(GetNamespaceRequest request) {
        request.withNamespaceName(this.namespaceName);
        GetNamespaceResult result = this.client.getNamespace(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, NamespaceDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public NamespaceDomain update(UpdateNamespaceRequest request) {
        request.withNamespaceName(this.namespaceName);
        UpdateNamespaceResult result = this.client.updateNamespace(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, NamespaceDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        NamespaceDomain domain = this;
        return domain;
    }

    public NamespaceDomain delete(DeleteNamespaceRequest request) {
        request.withNamespaceName(this.namespaceName);
        DeleteNamespaceResult result = null;
        try {
            result = this.client.deleteNamespace(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, NamespaceDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), Namespace.class);
        NamespaceDomain domain = this;
        return domain;
    }

    public ThresholdMasterDomain createThresholdMaster(CreateThresholdMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        CreateThresholdMasterResult result = this.client.createThresholdMaster(request);
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "ThresholdMaster");
        if (result.getItem() != null) {
            this.cache.put(parentKey, ThresholdMasterDomain.createCacheKey(result.getItem().getName() != null ? result.getItem().getName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        ThresholdMasterDomain domain = new ThresholdMasterDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), result.getItem().getName());
        return domain;
    }

    public ExperienceModelMasterDomain createExperienceModelMaster(CreateExperienceModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        CreateExperienceModelMasterResult result = this.client.createExperienceModelMaster(request);
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "ExperienceModelMaster");
        if (result.getItem() != null) {
            this.cache.put(parentKey, ExperienceModelMasterDomain.createCacheKey(result.getItem().getName() != null ? result.getItem().getName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        ExperienceModelMasterDomain domain = new ExperienceModelMasterDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), result.getItem().getName());
        return domain;
    }

    public CurrentExperienceMasterDomain currentExperienceMaster() {
        return new CurrentExperienceMasterDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName);
    }

    public DescribeExperienceModelsIterator experienceModels() {
        return new DescribeExperienceModelsIterator(this.cache, this.client, this.namespaceName);
    }

    public ExperienceModelDomain experienceModel(String experienceName) {
        return new ExperienceModelDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, experienceName);
    }

    public UserDomain user(String userId) {
        return new UserDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, userId);
    }

    public UserAccessTokenDomain accessToken(AccessToken accessToken) {
        return new UserAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, accessToken);
    }

    public DescribeThresholdMastersIterator thresholdMasters() {
        return new DescribeThresholdMastersIterator(this.cache, this.client, this.namespaceName);
    }

    public ThresholdMasterDomain thresholdMaster(String thresholdName) {
        return new ThresholdMasterDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, thresholdName);
    }

    public DescribeExperienceModelMastersIterator experienceModelMasters() {
        return new DescribeExperienceModelMastersIterator(this.cache, this.client, this.namespaceName);
    }

    public ExperienceModelMasterDomain experienceModelMaster(String experienceName) {
        return new ExperienceModelMasterDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, experienceName);
    }

    public static String createCacheParentKey(String namespaceName, String childType) {
        return String.join((CharSequence)":", "experience", namespaceName, childType);
    }

    public static String createCacheKey(String namespaceName) {
        return String.join((CharSequence)":", namespaceName);
    }

    public Namespace model() {
        Namespace value = this.cache.get(this.parentKey, NamespaceDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), Namespace.class);
        if (value == null) {
            try {
                this.get(new GetNamespaceRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, NamespaceDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), Namespace.class);
            }
            value = this.cache.get(this.parentKey, NamespaceDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), Namespace.class);
        }
        return value;
    }
}

