/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.experience.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.experience.Gs2ExperienceRestClient;
import io.gs2.experience.domain.model.NamespaceDomain;
import io.gs2.experience.model.ExperienceModelMaster;
import io.gs2.experience.request.DeleteExperienceModelMasterRequest;
import io.gs2.experience.request.GetExperienceModelMasterRequest;
import io.gs2.experience.request.UpdateExperienceModelMasterRequest;
import io.gs2.experience.result.DeleteExperienceModelMasterResult;
import io.gs2.experience.result.GetExperienceModelMasterResult;
import io.gs2.experience.result.UpdateExperienceModelMasterResult;

public class ExperienceModelMasterDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2ExperienceRestClient client;
    private final String namespaceName;
    private final String experienceName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getExperienceName() {
        return this.experienceName;
    }

    public ExperienceModelMasterDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String experienceName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2ExperienceRestClient(session);
        this.namespaceName = namespaceName;
        this.experienceName = experienceName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "ExperienceModelMaster");
    }

    private ExperienceModelMaster get(GetExperienceModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withExperienceName(this.experienceName);
        GetExperienceModelMasterResult result = this.client.getExperienceModelMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, ExperienceModelMasterDomain.createCacheKey(request.getExperienceName() != null ? request.getExperienceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public ExperienceModelMasterDomain update(UpdateExperienceModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withExperienceName(this.experienceName);
        UpdateExperienceModelMasterResult result = this.client.updateExperienceModelMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, ExperienceModelMasterDomain.createCacheKey(request.getExperienceName() != null ? request.getExperienceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        ExperienceModelMasterDomain domain = this;
        return domain;
    }

    public ExperienceModelMasterDomain delete(DeleteExperienceModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withExperienceName(this.experienceName);
        DeleteExperienceModelMasterResult result = null;
        try {
            result = this.client.deleteExperienceModelMaster(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, ExperienceModelMasterDomain.createCacheKey(request.getExperienceName() != null ? request.getExperienceName().toString() : null), ExperienceModelMaster.class);
        ExperienceModelMasterDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String experienceName, String childType) {
        return String.join((CharSequence)":", "experience", namespaceName, experienceName, childType);
    }

    public static String createCacheKey(String experienceName) {
        return String.join((CharSequence)":", experienceName);
    }

    public ExperienceModelMaster model() {
        ExperienceModelMaster value = this.cache.get(this.parentKey, ExperienceModelMasterDomain.createCacheKey(this.getExperienceName() != null ? this.getExperienceName().toString() : null), ExperienceModelMaster.class);
        if (value == null) {
            try {
                this.get(new GetExperienceModelMasterRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, ExperienceModelMasterDomain.createCacheKey(this.getExperienceName() != null ? this.getExperienceName().toString() : null), ExperienceModelMaster.class);
            }
            value = this.cache.get(this.parentKey, ExperienceModelMasterDomain.createCacheKey(this.getExperienceName() != null ? this.getExperienceName().toString() : null), ExperienceModelMaster.class);
        }
        return value;
    }
}

