/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.experience.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.experience.Gs2ExperienceRestClient;
import io.gs2.experience.domain.model.ExperienceModelDomain;
import io.gs2.experience.domain.model.NamespaceDomain;
import io.gs2.experience.model.ExperienceModel;
import io.gs2.experience.request.DescribeExperienceModelsRequest;
import io.gs2.experience.result.DescribeExperienceModelsResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeExperienceModelsIterator
implements Iterator<ExperienceModel>,
Iterable<ExperienceModel> {
    CacheDatabase cache;
    Gs2ExperienceRestClient client;
    String namespaceName;
    boolean last;
    List<ExperienceModel> result;
    Integer fetchSize;

    public DescribeExperienceModelsIterator(CacheDatabase cache, Gs2ExperienceRestClient client, String namespaceName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.last = false;
        this.result = new ArrayList<ExperienceModel>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "ExperienceModel");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, ExperienceModel.class)) {
            this.result = this.cache.list(parentKey, ExperienceModel.class).stream().collect(Collectors.toList());
            this.last = true;
        } else {
            DescribeExperienceModelsResult r = this.client.describeExperienceModels(new DescribeExperienceModelsRequest().withNamespaceName(this.namespaceName));
            this.result = r.getItems();
            this.last = true;
            for (ExperienceModel item : this.result) {
                this.cache.put(parentKey, ExperienceModelDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, ExperienceModel.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public ExperienceModel next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        ExperienceModel ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<ExperienceModel> iterator() {
        return this;
    }
}

