/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.experience.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.experience.Gs2ExperienceRestClient;
import io.gs2.experience.domain.model.ExperienceModelMasterDomain;
import io.gs2.experience.domain.model.NamespaceDomain;
import io.gs2.experience.model.ExperienceModelMaster;
import io.gs2.experience.request.DescribeExperienceModelMastersRequest;
import io.gs2.experience.result.DescribeExperienceModelMastersResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeExperienceModelMastersIterator
implements Iterator<ExperienceModelMaster>,
Iterable<ExperienceModelMaster> {
    CacheDatabase cache;
    Gs2ExperienceRestClient client;
    String namespaceName;
    String pageToken;
    boolean last;
    List<ExperienceModelMaster> result;
    Integer fetchSize;

    public DescribeExperienceModelMastersIterator(CacheDatabase cache, Gs2ExperienceRestClient client, String namespaceName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<ExperienceModelMaster>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "ExperienceModelMaster");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, ExperienceModelMaster.class)) {
            this.result = this.cache.list(parentKey, ExperienceModelMaster.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeExperienceModelMastersResult r = this.client.describeExperienceModelMasters(new DescribeExperienceModelMastersRequest().withNamespaceName(this.namespaceName).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (ExperienceModelMaster item : this.result) {
                this.cache.put(parentKey, ExperienceModelMasterDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, ExperienceModelMaster.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public ExperienceModelMaster next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        ExperienceModelMaster ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<ExperienceModelMaster> iterator() {
        return this;
    }
}

