/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.exchange.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.exchange.Gs2ExchangeRestClient;
import io.gs2.exchange.domain.iterator.DescribeAwaitsByUserIdIterator;
import io.gs2.exchange.domain.model.AwaitDomain;
import io.gs2.exchange.domain.model.ExchangeDomain;
import io.gs2.exchange.domain.model.NamespaceDomain;
import io.gs2.exchange.request.CreateAwaitByUserIdRequest;
import io.gs2.exchange.result.CreateAwaitByUserIdResult;

public class UserDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2ExchangeRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String parentKey;
    Long unlockAt;
    String nextPageToken;

    public Long getUnlockAt() {
        return this.unlockAt;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public UserDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2ExchangeRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "User");
    }

    public AwaitDomain createAwait(CreateAwaitByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId);
        CreateAwaitByUserIdResult result = this.client.createAwaitByUserId(request);
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Await");
        if (result.getItem() != null) {
            this.cache.put(parentKey, AwaitDomain.createCacheKey(result.getItem().getName() != null ? result.getItem().getName().toString() : null, request.getRateName() != null ? request.getRateName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        AwaitDomain domain = new AwaitDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), result.getItem().getUserId(), result.getItem().getName(), result.getItem().getRateName());
        domain.unlockAt = result.getUnlockAt();
        return domain;
    }

    public ExchangeDomain exchange() {
        return new ExchangeDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.userId);
    }

    public DescribeAwaitsByUserIdIterator awaits(String rateName) {
        return new DescribeAwaitsByUserIdIterator(this.cache, this.client, this.namespaceName, this.userId, rateName);
    }

    public AwaitDomain await(String awaitName, String rateName) {
        return new AwaitDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.userId, awaitName, rateName);
    }

    public static String createCacheParentKey(String namespaceName, String userId, String childType) {
        return String.join((CharSequence)":", "exchange", namespaceName, userId, childType);
    }

    public static String createCacheKey(String userId) {
        return String.join((CharSequence)":", userId);
    }
}

