/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.exchange.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.exchange.Gs2ExchangeRestClient;
import io.gs2.exchange.domain.model.NamespaceDomain;
import io.gs2.exchange.model.RateModelMaster;
import io.gs2.exchange.request.DeleteRateModelMasterRequest;
import io.gs2.exchange.request.GetRateModelMasterRequest;
import io.gs2.exchange.request.UpdateRateModelMasterRequest;
import io.gs2.exchange.result.DeleteRateModelMasterResult;
import io.gs2.exchange.result.GetRateModelMasterResult;
import io.gs2.exchange.result.UpdateRateModelMasterResult;

public class RateModelMasterDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2ExchangeRestClient client;
    private final String namespaceName;
    private final String rateName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getRateName() {
        return this.rateName;
    }

    public RateModelMasterDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String rateName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2ExchangeRestClient(session);
        this.namespaceName = namespaceName;
        this.rateName = rateName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "RateModelMaster");
    }

    private RateModelMaster get(GetRateModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withRateName(this.rateName);
        GetRateModelMasterResult result = this.client.getRateModelMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, RateModelMasterDomain.createCacheKey(request.getRateName() != null ? request.getRateName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public RateModelMasterDomain update(UpdateRateModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withRateName(this.rateName);
        UpdateRateModelMasterResult result = this.client.updateRateModelMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, RateModelMasterDomain.createCacheKey(request.getRateName() != null ? request.getRateName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        RateModelMasterDomain domain = this;
        return domain;
    }

    public RateModelMasterDomain delete(DeleteRateModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withRateName(this.rateName);
        DeleteRateModelMasterResult result = null;
        try {
            result = this.client.deleteRateModelMaster(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, RateModelMasterDomain.createCacheKey(request.getRateName() != null ? request.getRateName().toString() : null), RateModelMaster.class);
        RateModelMasterDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String rateName, String childType) {
        return String.join((CharSequence)":", "exchange", namespaceName, rateName, childType);
    }

    public static String createCacheKey(String rateName) {
        return String.join((CharSequence)":", rateName);
    }

    public RateModelMaster model() {
        RateModelMaster value = this.cache.get(this.parentKey, RateModelMasterDomain.createCacheKey(this.getRateName() != null ? this.getRateName().toString() : null), RateModelMaster.class);
        if (value == null) {
            try {
                this.get(new GetRateModelMasterRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, RateModelMasterDomain.createCacheKey(this.getRateName() != null ? this.getRateName().toString() : null), RateModelMaster.class);
            }
            value = this.cache.get(this.parentKey, RateModelMasterDomain.createCacheKey(this.getRateName() != null ? this.getRateName().toString() : null), RateModelMaster.class);
        }
        return value;
    }
}

