/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.exchange.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.domain.StampSheetDomain;
import io.gs2.core.exception.Gs2Exception;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.exception.TransactionException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.exchange.Gs2ExchangeRestClient;
import io.gs2.exchange.domain.model.AwaitDomain;
import io.gs2.exchange.domain.model.UserDomain;
import io.gs2.exchange.model.Await;
import io.gs2.exchange.request.AcquireRequest;
import io.gs2.exchange.request.DeleteAwaitRequest;
import io.gs2.exchange.request.GetAwaitRequest;
import io.gs2.exchange.request.SkipRequest;
import io.gs2.exchange.result.AcquireResult;
import io.gs2.exchange.result.DeleteAwaitResult;
import io.gs2.exchange.result.GetAwaitResult;
import io.gs2.exchange.result.SkipResult;

public class AwaitAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2ExchangeRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final String awaitName;
    private final String rateName;
    private final String parentKey;
    Long unlockAt;

    public Long getUnlockAt() {
        return this.unlockAt;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public String getAwaitName() {
        return this.awaitName;
    }

    public String getRateName() {
        return this.rateName;
    }

    public AwaitAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken, String awaitName, String rateName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2ExchangeRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.awaitName = awaitName;
        this.rateName = rateName;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "Await");
    }

    private Await get(GetAwaitRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withAwaitName(this.awaitName).withRateName(this.rateName);
        GetAwaitResult result = this.client.getAwait(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, AwaitDomain.createCacheKey(request.getAwaitName() != null ? request.getAwaitName().toString() : null, request.getRateName() != null ? request.getRateName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public StampSheetDomain acquire(AcquireRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withAwaitName(this.awaitName).withRateName(this.rateName);
        AcquireResult result = this.client.acquire(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, AwaitDomain.createCacheKey(request.getAwaitName() != null ? request.getAwaitName().toString() : null, request.getRateName() != null ? request.getRateName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        StampSheetDomain stampSheet = new StampSheetDomain(this.cache, this.jobQueueDomain, this.session, result.getStampSheet(), result.getStampSheetEncryptionKeyId(), this.stampSheetConfiguration.namespaceName, this.stampSheetConfiguration.stampTaskEventHandler, this.stampSheetConfiguration.stampSheetEventHandler);
        try {
            stampSheet.run();
        }
        catch (Gs2Exception e) {
            throw new TransactionException(stampSheet, e);
        }
        return stampSheet;
    }

    public StampSheetDomain skip(SkipRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withAwaitName(this.awaitName).withRateName(this.rateName);
        SkipResult result = this.client.skip(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, AwaitDomain.createCacheKey(request.getAwaitName() != null ? request.getAwaitName().toString() : null, request.getRateName() != null ? request.getRateName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        StampSheetDomain stampSheet = new StampSheetDomain(this.cache, this.jobQueueDomain, this.session, result.getStampSheet(), result.getStampSheetEncryptionKeyId(), this.stampSheetConfiguration.namespaceName, this.stampSheetConfiguration.stampTaskEventHandler, this.stampSheetConfiguration.stampSheetEventHandler);
        try {
            stampSheet.run();
        }
        catch (Gs2Exception e) {
            throw new TransactionException(stampSheet, e);
        }
        return stampSheet;
    }

    public AwaitAccessTokenDomain delete(DeleteAwaitRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withAwaitName(this.awaitName).withRateName(this.rateName);
        DeleteAwaitResult result = null;
        try {
            result = this.client.deleteAwait(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, AwaitDomain.createCacheKey(request.getAwaitName() != null ? request.getAwaitName().toString() : null, request.getRateName() != null ? request.getRateName().toString() : null), Await.class);
        AwaitAccessTokenDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String awaitName, String rateName, String childType) {
        return String.join((CharSequence)":", "exchange", namespaceName, userId, awaitName, rateName, childType);
    }

    public static String createCacheKey(String awaitName, String rateName) {
        return String.join((CharSequence)":", awaitName, rateName);
    }

    public Await model() {
        Await value = this.cache.get(this.parentKey, AwaitDomain.createCacheKey(this.getAwaitName() != null ? this.getAwaitName().toString() : null, this.getRateName() != null ? this.getRateName().toString() : null), Await.class);
        if (value == null) {
            try {
                this.get(new GetAwaitRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, AwaitDomain.createCacheKey(this.getAwaitName() != null ? this.getAwaitName().toString() : null, this.getRateName() != null ? this.getRateName().toString() : null), Await.class);
            }
            value = this.cache.get(this.parentKey, AwaitDomain.createCacheKey(this.getAwaitName() != null ? this.getAwaitName().toString() : null, this.getRateName() != null ? this.getRateName().toString() : null), Await.class);
        }
        return value;
    }
}

