/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.exchange.domain;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.exchange.Gs2ExchangeRestClient;
import io.gs2.exchange.domain.iterator.DescribeNamespacesIterator;
import io.gs2.exchange.domain.model.AwaitDomain;
import io.gs2.exchange.domain.model.ExchangeDomain;
import io.gs2.exchange.domain.model.NamespaceDomain;
import io.gs2.exchange.domain.model.UserDomain;
import io.gs2.exchange.model.Await;
import io.gs2.exchange.request.CreateAwaitByUserIdRequest;
import io.gs2.exchange.request.CreateNamespaceRequest;
import io.gs2.exchange.request.DeleteAwaitByUserIdRequest;
import io.gs2.exchange.request.ExchangeByUserIdRequest;
import io.gs2.exchange.result.CreateAwaitByUserIdResult;
import io.gs2.exchange.result.CreateNamespaceResult;
import io.gs2.exchange.result.DeleteAwaitByUserIdResult;
import io.gs2.exchange.result.ExchangeByUserIdResult;
import io.gs2.jobQueue.model.Job;
import io.gs2.jobQueue.model.JobResultBody;

public class Gs2Exchange {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2ExchangeRestClient client;
    private final String parentKey;

    public Gs2Exchange(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2ExchangeRestClient(session);
        this.parentKey = "exchange";
    }

    public NamespaceDomain createNamespace(CreateNamespaceRequest request) {
        CreateNamespaceResult result = this.client.createNamespace(request);
        String parentKey = "exchange:Namespace";
        if (result.getItem() != null) {
            this.cache.put(parentKey, NamespaceDomain.createCacheKey(result.getItem().getName() != null ? result.getItem().getName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        NamespaceDomain domain = new NamespaceDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, result.getItem().getName());
        return domain;
    }

    public DescribeNamespacesIterator namespaces() {
        return new DescribeNamespacesIterator(this.cache, this.client);
    }

    public NamespaceDomain namespace(String namespaceName) {
        return new NamespaceDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, namespaceName);
    }

    public static void updateCacheFromStampSheet(CacheDatabase cache, String method, String request, String result) {
        try {
            switch (method) {
                case "ExchangeByUserId": {
                    ExchangeByUserIdRequest requestModel = ExchangeByUserIdRequest.fromJson(new ObjectMapper().readTree(request));
                    ExchangeByUserIdResult resultModel = ExchangeByUserIdResult.fromJson(new ObjectMapper().readTree(result));
                    String parentKey = UserDomain.createCacheParentKey(requestModel.getNamespaceName().toString(), requestModel.getUserId().toString(), "Exchange");
                    String key = ExchangeDomain.createCacheKey();
                    cache.put(parentKey, key, resultModel.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
                    break;
                }
                case "CreateAwaitByUserId": {
                    CreateAwaitByUserIdRequest requestModel = CreateAwaitByUserIdRequest.fromJson(new ObjectMapper().readTree(request));
                    CreateAwaitByUserIdResult resultModel = CreateAwaitByUserIdResult.fromJson(new ObjectMapper().readTree(result));
                    String parentKey = UserDomain.createCacheParentKey(requestModel.getNamespaceName().toString(), resultModel.getItem().getUserId().toString(), "Await");
                    String key = AwaitDomain.createCacheKey(resultModel.getItem().getName().toString(), resultModel.getItem().getRateName().toString());
                    cache.put(parentKey, key, resultModel.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
                    break;
                }
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public static void updateCacheFromStampTask(CacheDatabase cache, String method, String request, String result) {
        try {
            switch (method) {
                case "DeleteAwaitByUserId": {
                    DeleteAwaitByUserIdRequest requestModel = DeleteAwaitByUserIdRequest.fromJson(new ObjectMapper().readTree(request));
                    DeleteAwaitByUserIdResult resultModel = DeleteAwaitByUserIdResult.fromJson(new ObjectMapper().readTree(result));
                    String parentKey = UserDomain.createCacheParentKey(requestModel.getNamespaceName().toString(), resultModel.getItem().getUserId().toString(), "Await");
                    String key = AwaitDomain.createCacheKey(resultModel.getItem().getName().toString(), resultModel.getItem().getRateName().toString());
                    cache.delete(parentKey, key, Await.class);
                    break;
                }
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public static void updateCacheFromJobResult(CacheDatabase cache, String method, Job job, JobResultBody result) {
        try {
            switch (method) {
                case "exchange_by_user_id": {
                    ExchangeByUserIdRequest requestModel = ExchangeByUserIdRequest.fromJson(new ObjectMapper().readTree(job.getArgs()));
                    ExchangeByUserIdResult resultModel = ExchangeByUserIdResult.fromJson(new ObjectMapper().readTree(result.getResult()));
                    String parentKey = UserDomain.createCacheParentKey(requestModel.getNamespaceName().toString(), requestModel.getUserId().toString(), "Exchange");
                    String key = ExchangeDomain.createCacheKey();
                    cache.put(parentKey, key, resultModel.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
                    break;
                }
                case "create_await_by_user_id": {
                    CreateAwaitByUserIdRequest requestModel = CreateAwaitByUserIdRequest.fromJson(new ObjectMapper().readTree(job.getArgs()));
                    CreateAwaitByUserIdResult resultModel = CreateAwaitByUserIdResult.fromJson(new ObjectMapper().readTree(result.getResult()));
                    String parentKey = UserDomain.createCacheParentKey(requestModel.getNamespaceName().toString(), resultModel.getItem().getUserId().toString(), "Await");
                    String key = AwaitDomain.createCacheKey(resultModel.getItem().getName().toString(), resultModel.getItem().getRateName().toString());
                    cache.put(parentKey, key, resultModel.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
                    break;
                }
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }
}

