/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.enhance.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.domain.StampSheetDomain;
import io.gs2.core.exception.Gs2Exception;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.exception.TransactionException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.enhance.Gs2EnhanceRestClient;
import io.gs2.enhance.domain.model.ProgressDomain;
import io.gs2.enhance.domain.model.RateModelDomain;
import io.gs2.enhance.domain.model.UserDomain;
import io.gs2.enhance.model.Progress;
import io.gs2.enhance.request.DeleteProgressRequest;
import io.gs2.enhance.request.EndRequest;
import io.gs2.enhance.request.GetProgressRequest;
import io.gs2.enhance.request.StartRequest;
import io.gs2.enhance.result.DeleteProgressResult;
import io.gs2.enhance.result.EndResult;
import io.gs2.enhance.result.GetProgressResult;
import io.gs2.enhance.result.StartResult;

public class ProgressAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2EnhanceRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final String parentKey;
    Long acquireExperience;
    Float bonusRate;

    public Long getAcquireExperience() {
        return this.acquireExperience;
    }

    public Float getBonusRate() {
        return this.bonusRate;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public ProgressAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2EnhanceRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "Progress");
    }

    private Progress get(GetProgressRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null);
        GetProgressResult result = this.client.getProgress(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, ProgressDomain.createCacheKey(), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        if (result.getRateModel() != null) {
            this.cache.put(this.parentKey, RateModelDomain.createCacheKey(result.getRateModel().getName() != null ? result.getRateModel().getName().toString() : null), result.getRateModel(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public StampSheetDomain start(StartRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null);
        StartResult result = this.client.start(request);
        StampSheetDomain stampSheet = new StampSheetDomain(this.cache, this.jobQueueDomain, this.session, result.getStampSheet(), result.getStampSheetEncryptionKeyId(), this.stampSheetConfiguration.namespaceName, this.stampSheetConfiguration.stampTaskEventHandler, this.stampSheetConfiguration.stampSheetEventHandler);
        try {
            stampSheet.run();
        }
        catch (Gs2Exception e) {
            throw new TransactionException(stampSheet, e);
        }
        return stampSheet;
    }

    public StampSheetDomain end(EndRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null);
        EndResult result = this.client.end(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, ProgressDomain.createCacheKey(), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        StampSheetDomain stampSheet = new StampSheetDomain(this.cache, this.jobQueueDomain, this.session, result.getStampSheet(), result.getStampSheetEncryptionKeyId(), this.stampSheetConfiguration.namespaceName, this.stampSheetConfiguration.stampTaskEventHandler, this.stampSheetConfiguration.stampSheetEventHandler);
        try {
            stampSheet.run();
        }
        catch (Gs2Exception e) {
            throw new TransactionException(stampSheet, e);
        }
        return stampSheet;
    }

    public ProgressAccessTokenDomain delete(DeleteProgressRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null);
        DeleteProgressResult result = null;
        try {
            result = this.client.deleteProgress(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, ProgressDomain.createCacheKey(), Progress.class);
        ProgressAccessTokenDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String childType) {
        return String.join((CharSequence)":", "enhance", namespaceName, userId, childType);
    }

    public static String createCacheKey() {
        return "Singleton";
    }

    public Progress model() {
        Progress value = this.cache.get(this.parentKey, ProgressDomain.createCacheKey(), Progress.class);
        if (value == null) {
            try {
                this.get(new GetProgressRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, ProgressDomain.createCacheKey(), Progress.class);
            }
            value = this.cache.get(this.parentKey, ProgressDomain.createCacheKey(), Progress.class);
        }
        return value;
    }
}

