/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.enhance.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.enhance.Gs2EnhanceRestClient;
import io.gs2.enhance.domain.model.NamespaceDomain;
import io.gs2.enhance.domain.model.RateModelMasterDomain;
import io.gs2.enhance.model.RateModelMaster;
import io.gs2.enhance.request.DescribeRateModelMastersRequest;
import io.gs2.enhance.result.DescribeRateModelMastersResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeRateModelMastersIterator
implements Iterator<RateModelMaster>,
Iterable<RateModelMaster> {
    CacheDatabase cache;
    Gs2EnhanceRestClient client;
    String namespaceName;
    String pageToken;
    boolean last;
    List<RateModelMaster> result;
    Integer fetchSize;

    public DescribeRateModelMastersIterator(CacheDatabase cache, Gs2EnhanceRestClient client, String namespaceName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<RateModelMaster>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "RateModelMaster");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, RateModelMaster.class)) {
            this.result = this.cache.list(parentKey, RateModelMaster.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeRateModelMastersResult r = this.client.describeRateModelMasters(new DescribeRateModelMastersRequest().withNamespaceName(this.namespaceName).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (RateModelMaster item : this.result) {
                this.cache.put(parentKey, RateModelMasterDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, RateModelMaster.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public RateModelMaster next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        RateModelMaster ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<RateModelMaster> iterator() {
        return this;
    }
}

