/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.enhance;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.AbstractGs2Client;
import io.gs2.core.model.AsyncAction;
import io.gs2.core.model.AsyncResult;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.core.net.Gs2RestSessionTask;
import io.gs2.core.net.HttpTask;
import io.gs2.core.util.EncodingUtil;
import io.gs2.enhance.request.CreateNamespaceRequest;
import io.gs2.enhance.request.CreateProgressByStampSheetRequest;
import io.gs2.enhance.request.CreateProgressByUserIdRequest;
import io.gs2.enhance.request.CreateRateModelMasterRequest;
import io.gs2.enhance.request.DeleteNamespaceRequest;
import io.gs2.enhance.request.DeleteProgressByStampTaskRequest;
import io.gs2.enhance.request.DeleteProgressByUserIdRequest;
import io.gs2.enhance.request.DeleteProgressRequest;
import io.gs2.enhance.request.DeleteRateModelMasterRequest;
import io.gs2.enhance.request.DescribeNamespacesRequest;
import io.gs2.enhance.request.DescribeProgressesByUserIdRequest;
import io.gs2.enhance.request.DescribeRateModelMastersRequest;
import io.gs2.enhance.request.DescribeRateModelsRequest;
import io.gs2.enhance.request.DirectEnhanceByStampSheetRequest;
import io.gs2.enhance.request.DirectEnhanceByUserIdRequest;
import io.gs2.enhance.request.DirectEnhanceRequest;
import io.gs2.enhance.request.EndByUserIdRequest;
import io.gs2.enhance.request.EndRequest;
import io.gs2.enhance.request.ExportMasterRequest;
import io.gs2.enhance.request.GetCurrentRateMasterRequest;
import io.gs2.enhance.request.GetNamespaceRequest;
import io.gs2.enhance.request.GetNamespaceStatusRequest;
import io.gs2.enhance.request.GetProgressByUserIdRequest;
import io.gs2.enhance.request.GetProgressRequest;
import io.gs2.enhance.request.GetRateModelMasterRequest;
import io.gs2.enhance.request.GetRateModelRequest;
import io.gs2.enhance.request.StartByUserIdRequest;
import io.gs2.enhance.request.StartRequest;
import io.gs2.enhance.request.UpdateCurrentRateMasterFromGitHubRequest;
import io.gs2.enhance.request.UpdateCurrentRateMasterRequest;
import io.gs2.enhance.request.UpdateNamespaceRequest;
import io.gs2.enhance.request.UpdateRateModelMasterRequest;
import io.gs2.enhance.result.CreateNamespaceResult;
import io.gs2.enhance.result.CreateProgressByStampSheetResult;
import io.gs2.enhance.result.CreateProgressByUserIdResult;
import io.gs2.enhance.result.CreateRateModelMasterResult;
import io.gs2.enhance.result.DeleteNamespaceResult;
import io.gs2.enhance.result.DeleteProgressByStampTaskResult;
import io.gs2.enhance.result.DeleteProgressByUserIdResult;
import io.gs2.enhance.result.DeleteProgressResult;
import io.gs2.enhance.result.DeleteRateModelMasterResult;
import io.gs2.enhance.result.DescribeNamespacesResult;
import io.gs2.enhance.result.DescribeProgressesByUserIdResult;
import io.gs2.enhance.result.DescribeRateModelMastersResult;
import io.gs2.enhance.result.DescribeRateModelsResult;
import io.gs2.enhance.result.DirectEnhanceByStampSheetResult;
import io.gs2.enhance.result.DirectEnhanceByUserIdResult;
import io.gs2.enhance.result.DirectEnhanceResult;
import io.gs2.enhance.result.EndByUserIdResult;
import io.gs2.enhance.result.EndResult;
import io.gs2.enhance.result.ExportMasterResult;
import io.gs2.enhance.result.GetCurrentRateMasterResult;
import io.gs2.enhance.result.GetNamespaceResult;
import io.gs2.enhance.result.GetNamespaceStatusResult;
import io.gs2.enhance.result.GetProgressByUserIdResult;
import io.gs2.enhance.result.GetProgressResult;
import io.gs2.enhance.result.GetRateModelMasterResult;
import io.gs2.enhance.result.GetRateModelResult;
import io.gs2.enhance.result.StartByUserIdResult;
import io.gs2.enhance.result.StartResult;
import io.gs2.enhance.result.UpdateCurrentRateMasterFromGitHubResult;
import io.gs2.enhance.result.UpdateCurrentRateMasterResult;
import io.gs2.enhance.result.UpdateNamespaceResult;
import io.gs2.enhance.result.UpdateRateModelMasterResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.stream.Collectors;

public class Gs2EnhanceRestClient
extends AbstractGs2Client<Gs2EnhanceRestClient> {
    public Gs2EnhanceRestClient(Gs2RestSession gs2RestSession) {
        super(gs2RestSession);
    }

    public void describeNamespacesAsync(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> callback) {
        DescribeNamespacesTask task = new DescribeNamespacesTask(request, callback);
        this.session.execute(task);
    }

    public DescribeNamespacesResult describeNamespaces(DescribeNamespacesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeNamespacesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeNamespacesResult)resultAsyncResult[0].getResult();
    }

    public void createNamespaceAsync(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> callback) {
        CreateNamespaceTask task = new CreateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public CreateNamespaceResult createNamespace(CreateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceStatusAsync(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> callback) {
        GetNamespaceStatusTask task = new GetNamespaceStatusTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceStatusResult getNamespaceStatus(GetNamespaceStatusRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceStatusAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceStatusResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceAsync(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> callback) {
        GetNamespaceTask task = new GetNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceResult getNamespace(GetNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void updateNamespaceAsync(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> callback) {
        UpdateNamespaceTask task = new UpdateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public UpdateNamespaceResult updateNamespace(UpdateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void deleteNamespaceAsync(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> callback) {
        DeleteNamespaceTask task = new DeleteNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public DeleteNamespaceResult deleteNamespace(DeleteNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void describeRateModelsAsync(DescribeRateModelsRequest request, AsyncAction<AsyncResult<DescribeRateModelsResult>> callback) {
        DescribeRateModelsTask task = new DescribeRateModelsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeRateModelsResult describeRateModels(DescribeRateModelsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeRateModelsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeRateModelsResult)resultAsyncResult[0].getResult();
    }

    public void getRateModelAsync(GetRateModelRequest request, AsyncAction<AsyncResult<GetRateModelResult>> callback) {
        GetRateModelTask task = new GetRateModelTask(request, callback);
        this.session.execute(task);
    }

    public GetRateModelResult getRateModel(GetRateModelRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getRateModelAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetRateModelResult)resultAsyncResult[0].getResult();
    }

    public void describeRateModelMastersAsync(DescribeRateModelMastersRequest request, AsyncAction<AsyncResult<DescribeRateModelMastersResult>> callback) {
        DescribeRateModelMastersTask task = new DescribeRateModelMastersTask(request, callback);
        this.session.execute(task);
    }

    public DescribeRateModelMastersResult describeRateModelMasters(DescribeRateModelMastersRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeRateModelMastersAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeRateModelMastersResult)resultAsyncResult[0].getResult();
    }

    public void createRateModelMasterAsync(CreateRateModelMasterRequest request, AsyncAction<AsyncResult<CreateRateModelMasterResult>> callback) {
        CreateRateModelMasterTask task = new CreateRateModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public CreateRateModelMasterResult createRateModelMaster(CreateRateModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createRateModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateRateModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void getRateModelMasterAsync(GetRateModelMasterRequest request, AsyncAction<AsyncResult<GetRateModelMasterResult>> callback) {
        GetRateModelMasterTask task = new GetRateModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public GetRateModelMasterResult getRateModelMaster(GetRateModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getRateModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetRateModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateRateModelMasterAsync(UpdateRateModelMasterRequest request, AsyncAction<AsyncResult<UpdateRateModelMasterResult>> callback) {
        UpdateRateModelMasterTask task = new UpdateRateModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public UpdateRateModelMasterResult updateRateModelMaster(UpdateRateModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateRateModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateRateModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void deleteRateModelMasterAsync(DeleteRateModelMasterRequest request, AsyncAction<AsyncResult<DeleteRateModelMasterResult>> callback) {
        DeleteRateModelMasterTask task = new DeleteRateModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public DeleteRateModelMasterResult deleteRateModelMaster(DeleteRateModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteRateModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteRateModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void directEnhanceAsync(DirectEnhanceRequest request, AsyncAction<AsyncResult<DirectEnhanceResult>> callback) {
        DirectEnhanceTask task = new DirectEnhanceTask(request, callback);
        this.session.execute(task);
    }

    public DirectEnhanceResult directEnhance(DirectEnhanceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.directEnhanceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DirectEnhanceResult)resultAsyncResult[0].getResult();
    }

    public void directEnhanceByUserIdAsync(DirectEnhanceByUserIdRequest request, AsyncAction<AsyncResult<DirectEnhanceByUserIdResult>> callback) {
        DirectEnhanceByUserIdTask task = new DirectEnhanceByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DirectEnhanceByUserIdResult directEnhanceByUserId(DirectEnhanceByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.directEnhanceByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DirectEnhanceByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void directEnhanceByStampSheetAsync(DirectEnhanceByStampSheetRequest request, AsyncAction<AsyncResult<DirectEnhanceByStampSheetResult>> callback) {
        DirectEnhanceByStampSheetTask task = new DirectEnhanceByStampSheetTask(request, callback);
        this.session.execute(task);
    }

    public DirectEnhanceByStampSheetResult directEnhanceByStampSheet(DirectEnhanceByStampSheetRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.directEnhanceByStampSheetAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DirectEnhanceByStampSheetResult)resultAsyncResult[0].getResult();
    }

    public void describeProgressesByUserIdAsync(DescribeProgressesByUserIdRequest request, AsyncAction<AsyncResult<DescribeProgressesByUserIdResult>> callback) {
        DescribeProgressesByUserIdTask task = new DescribeProgressesByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DescribeProgressesByUserIdResult describeProgressesByUserId(DescribeProgressesByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeProgressesByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeProgressesByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void createProgressByUserIdAsync(CreateProgressByUserIdRequest request, AsyncAction<AsyncResult<CreateProgressByUserIdResult>> callback) {
        CreateProgressByUserIdTask task = new CreateProgressByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CreateProgressByUserIdResult createProgressByUserId(CreateProgressByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createProgressByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateProgressByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void getProgressAsync(GetProgressRequest request, AsyncAction<AsyncResult<GetProgressResult>> callback) {
        GetProgressTask task = new GetProgressTask(request, callback);
        this.session.execute(task);
    }

    public GetProgressResult getProgress(GetProgressRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getProgressAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetProgressResult)resultAsyncResult[0].getResult();
    }

    public void getProgressByUserIdAsync(GetProgressByUserIdRequest request, AsyncAction<AsyncResult<GetProgressByUserIdResult>> callback) {
        GetProgressByUserIdTask task = new GetProgressByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public GetProgressByUserIdResult getProgressByUserId(GetProgressByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getProgressByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetProgressByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void startAsync(StartRequest request, AsyncAction<AsyncResult<StartResult>> callback) {
        StartTask task = new StartTask(request, callback);
        this.session.execute(task);
    }

    public StartResult start(StartRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.startAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (StartResult)resultAsyncResult[0].getResult();
    }

    public void startByUserIdAsync(StartByUserIdRequest request, AsyncAction<AsyncResult<StartByUserIdResult>> callback) {
        StartByUserIdTask task = new StartByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public StartByUserIdResult startByUserId(StartByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.startByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (StartByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void endAsync(EndRequest request, AsyncAction<AsyncResult<EndResult>> callback) {
        EndTask task = new EndTask(request, callback);
        this.session.execute(task);
    }

    public EndResult end(EndRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.endAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (EndResult)resultAsyncResult[0].getResult();
    }

    public void endByUserIdAsync(EndByUserIdRequest request, AsyncAction<AsyncResult<EndByUserIdResult>> callback) {
        EndByUserIdTask task = new EndByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public EndByUserIdResult endByUserId(EndByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.endByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (EndByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void deleteProgressAsync(DeleteProgressRequest request, AsyncAction<AsyncResult<DeleteProgressResult>> callback) {
        DeleteProgressTask task = new DeleteProgressTask(request, callback);
        this.session.execute(task);
    }

    public DeleteProgressResult deleteProgress(DeleteProgressRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteProgressAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteProgressResult)resultAsyncResult[0].getResult();
    }

    public void deleteProgressByUserIdAsync(DeleteProgressByUserIdRequest request, AsyncAction<AsyncResult<DeleteProgressByUserIdResult>> callback) {
        DeleteProgressByUserIdTask task = new DeleteProgressByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DeleteProgressByUserIdResult deleteProgressByUserId(DeleteProgressByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteProgressByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteProgressByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void createProgressByStampSheetAsync(CreateProgressByStampSheetRequest request, AsyncAction<AsyncResult<CreateProgressByStampSheetResult>> callback) {
        CreateProgressByStampSheetTask task = new CreateProgressByStampSheetTask(request, callback);
        this.session.execute(task);
    }

    public CreateProgressByStampSheetResult createProgressByStampSheet(CreateProgressByStampSheetRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createProgressByStampSheetAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateProgressByStampSheetResult)resultAsyncResult[0].getResult();
    }

    public void deleteProgressByStampTaskAsync(DeleteProgressByStampTaskRequest request, AsyncAction<AsyncResult<DeleteProgressByStampTaskResult>> callback) {
        DeleteProgressByStampTaskTask task = new DeleteProgressByStampTaskTask(request, callback);
        this.session.execute(task);
    }

    public DeleteProgressByStampTaskResult deleteProgressByStampTask(DeleteProgressByStampTaskRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteProgressByStampTaskAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteProgressByStampTaskResult)resultAsyncResult[0].getResult();
    }

    public void exportMasterAsync(ExportMasterRequest request, AsyncAction<AsyncResult<ExportMasterResult>> callback) {
        ExportMasterTask task = new ExportMasterTask(request, callback);
        this.session.execute(task);
    }

    public ExportMasterResult exportMaster(ExportMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.exportMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ExportMasterResult)resultAsyncResult[0].getResult();
    }

    public void getCurrentRateMasterAsync(GetCurrentRateMasterRequest request, AsyncAction<AsyncResult<GetCurrentRateMasterResult>> callback) {
        GetCurrentRateMasterTask task = new GetCurrentRateMasterTask(request, callback);
        this.session.execute(task);
    }

    public GetCurrentRateMasterResult getCurrentRateMaster(GetCurrentRateMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getCurrentRateMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetCurrentRateMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateCurrentRateMasterAsync(UpdateCurrentRateMasterRequest request, AsyncAction<AsyncResult<UpdateCurrentRateMasterResult>> callback) {
        UpdateCurrentRateMasterTask task = new UpdateCurrentRateMasterTask(request, callback);
        this.session.execute(task);
    }

    public UpdateCurrentRateMasterResult updateCurrentRateMaster(UpdateCurrentRateMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateCurrentRateMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateCurrentRateMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateCurrentRateMasterFromGitHubAsync(UpdateCurrentRateMasterFromGitHubRequest request, AsyncAction<AsyncResult<UpdateCurrentRateMasterFromGitHubResult>> callback) {
        UpdateCurrentRateMasterFromGitHubTask task = new UpdateCurrentRateMasterFromGitHubTask(request, callback);
        this.session.execute(task);
    }

    public UpdateCurrentRateMasterFromGitHubResult updateCurrentRateMasterFromGitHub(UpdateCurrentRateMasterFromGitHubRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateCurrentRateMasterFromGitHubAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateCurrentRateMasterFromGitHubResult)resultAsyncResult[0].getResult();
    }

    class UpdateCurrentRateMasterFromGitHubTask
    extends Gs2RestSessionTask<UpdateCurrentRateMasterFromGitHubResult> {
        private UpdateCurrentRateMasterFromGitHubRequest request;

        public UpdateCurrentRateMasterFromGitHubTask(UpdateCurrentRateMasterFromGitHubRequest request, AsyncAction<AsyncResult<UpdateCurrentRateMasterFromGitHubResult>> userCallback) {
            super((Gs2RestSession)Gs2EnhanceRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateCurrentRateMasterFromGitHubResult parse(JsonNode data) {
            return UpdateCurrentRateMasterFromGitHubResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "enhance").replace("{region}", Gs2EnhanceRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/from_git_hub";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("checkoutSetting", UpdateCurrentRateMasterFromGitHubTask.this.request.getCheckoutSetting() != null ? UpdateCurrentRateMasterFromGitHubTask.this.request.getCheckoutSetting().toJson() : null);
                    this.put("contextStack", UpdateCurrentRateMasterFromGitHubTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateCurrentRateMasterTask
    extends Gs2RestSessionTask<UpdateCurrentRateMasterResult> {
        private UpdateCurrentRateMasterRequest request;

        public UpdateCurrentRateMasterTask(UpdateCurrentRateMasterRequest request, AsyncAction<AsyncResult<UpdateCurrentRateMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2EnhanceRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateCurrentRateMasterResult parse(JsonNode data) {
            return UpdateCurrentRateMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "enhance").replace("{region}", Gs2EnhanceRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("settings", UpdateCurrentRateMasterTask.this.request.getSettings());
                    this.put("contextStack", UpdateCurrentRateMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetCurrentRateMasterTask
    extends Gs2RestSessionTask<GetCurrentRateMasterResult> {
        private GetCurrentRateMasterRequest request;

        public GetCurrentRateMasterTask(GetCurrentRateMasterRequest request, AsyncAction<AsyncResult<GetCurrentRateMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2EnhanceRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetCurrentRateMasterResult parse(JsonNode data) {
            return GetCurrentRateMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "enhance").replace("{region}", Gs2EnhanceRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class ExportMasterTask
    extends Gs2RestSessionTask<ExportMasterResult> {
        private ExportMasterRequest request;

        public ExportMasterTask(ExportMasterRequest request, AsyncAction<AsyncResult<ExportMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2EnhanceRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ExportMasterResult parse(JsonNode data) {
            return ExportMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "enhance").replace("{region}", Gs2EnhanceRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/export";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteProgressByStampTaskTask
    extends Gs2RestSessionTask<DeleteProgressByStampTaskResult> {
        private DeleteProgressByStampTaskRequest request;

        public DeleteProgressByStampTaskTask(DeleteProgressByStampTaskRequest request, AsyncAction<AsyncResult<DeleteProgressByStampTaskResult>> userCallback) {
            super((Gs2RestSession)Gs2EnhanceRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteProgressByStampTaskResult parse(JsonNode data) {
            return DeleteProgressByStampTaskResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "enhance").replace("{region}", Gs2EnhanceRestClient.this.session.getRegion().getName()) + "/stamp/progress/delete";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampTask", DeleteProgressByStampTaskTask.this.request.getStampTask());
                    this.put("keyId", DeleteProgressByStampTaskTask.this.request.getKeyId());
                    this.put("contextStack", DeleteProgressByStampTaskTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateProgressByStampSheetTask
    extends Gs2RestSessionTask<CreateProgressByStampSheetResult> {
        private CreateProgressByStampSheetRequest request;

        public CreateProgressByStampSheetTask(CreateProgressByStampSheetRequest request, AsyncAction<AsyncResult<CreateProgressByStampSheetResult>> userCallback) {
            super((Gs2RestSession)Gs2EnhanceRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateProgressByStampSheetResult parse(JsonNode data) {
            return CreateProgressByStampSheetResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "enhance").replace("{region}", Gs2EnhanceRestClient.this.session.getRegion().getName()) + "/stamp/progress/create";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampSheet", CreateProgressByStampSheetTask.this.request.getStampSheet());
                    this.put("keyId", CreateProgressByStampSheetTask.this.request.getKeyId());
                    this.put("contextStack", CreateProgressByStampSheetTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteProgressByUserIdTask
    extends Gs2RestSessionTask<DeleteProgressByUserIdResult> {
        private DeleteProgressByUserIdRequest request;

        public DeleteProgressByUserIdTask(DeleteProgressByUserIdRequest request, AsyncAction<AsyncResult<DeleteProgressByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2EnhanceRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteProgressByUserIdResult parse(JsonNode data) {
            return DeleteProgressByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "enhance").replace("{region}", Gs2EnhanceRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/progress";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteProgressTask
    extends Gs2RestSessionTask<DeleteProgressResult> {
        private DeleteProgressRequest request;

        public DeleteProgressTask(DeleteProgressRequest request, AsyncAction<AsyncResult<DeleteProgressResult>> userCallback) {
            super((Gs2RestSession)Gs2EnhanceRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteProgressResult parse(JsonNode data) {
            return DeleteProgressResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "enhance").replace("{region}", Gs2EnhanceRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/progress";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class EndByUserIdTask
    extends Gs2RestSessionTask<EndByUserIdResult> {
        private EndByUserIdRequest request;

        public EndByUserIdTask(EndByUserIdRequest request, AsyncAction<AsyncResult<EndByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2EnhanceRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public EndByUserIdResult parse(JsonNode data) {
            return EndByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "enhance").replace("{region}", Gs2EnhanceRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/progress/end";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("config", EndByUserIdTask.this.request.getConfig() == null ? new ArrayList() : EndByUserIdTask.this.request.getConfig().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", EndByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class EndTask
    extends Gs2RestSessionTask<EndResult> {
        private EndRequest request;

        public EndTask(EndRequest request, AsyncAction<AsyncResult<EndResult>> userCallback) {
            super((Gs2RestSession)Gs2EnhanceRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public EndResult parse(JsonNode data) {
            return EndResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "enhance").replace("{region}", Gs2EnhanceRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/progress/end";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("config", EndTask.this.request.getConfig() == null ? new ArrayList() : EndTask.this.request.getConfig().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", EndTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class StartByUserIdTask
    extends Gs2RestSessionTask<StartByUserIdResult> {
        private StartByUserIdRequest request;

        public StartByUserIdTask(StartByUserIdRequest request, AsyncAction<AsyncResult<StartByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2EnhanceRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public StartByUserIdResult parse(JsonNode data) {
            return StartByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "enhance").replace("{region}", Gs2EnhanceRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/progress/rate/{rateName}/start";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{rateName}", this.request.getRateName() == null || this.request.getRateName().length() == 0 ? "null" : String.valueOf(this.request.getRateName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("targetItemSetId", StartByUserIdTask.this.request.getTargetItemSetId());
                    this.put("materials", StartByUserIdTask.this.request.getMaterials() == null ? new ArrayList() : StartByUserIdTask.this.request.getMaterials().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("force", StartByUserIdTask.this.request.getForce());
                    this.put("config", StartByUserIdTask.this.request.getConfig() == null ? new ArrayList() : StartByUserIdTask.this.request.getConfig().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", StartByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class StartTask
    extends Gs2RestSessionTask<StartResult> {
        private StartRequest request;

        public StartTask(StartRequest request, AsyncAction<AsyncResult<StartResult>> userCallback) {
            super((Gs2RestSession)Gs2EnhanceRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public StartResult parse(JsonNode data) {
            return StartResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "enhance").replace("{region}", Gs2EnhanceRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/progress/rate/{rateName}/start";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{rateName}", this.request.getRateName() == null || this.request.getRateName().length() == 0 ? "null" : String.valueOf(this.request.getRateName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("targetItemSetId", StartTask.this.request.getTargetItemSetId());
                    this.put("materials", StartTask.this.request.getMaterials() == null ? new ArrayList() : StartTask.this.request.getMaterials().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("force", StartTask.this.request.getForce());
                    this.put("config", StartTask.this.request.getConfig() == null ? new ArrayList() : StartTask.this.request.getConfig().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", StartTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class GetProgressByUserIdTask
    extends Gs2RestSessionTask<GetProgressByUserIdResult> {
        private GetProgressByUserIdRequest request;

        public GetProgressByUserIdTask(GetProgressByUserIdRequest request, AsyncAction<AsyncResult<GetProgressByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2EnhanceRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetProgressByUserIdResult parse(JsonNode data) {
            return GetProgressByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "enhance").replace("{region}", Gs2EnhanceRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/progress";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetProgressTask
    extends Gs2RestSessionTask<GetProgressResult> {
        private GetProgressRequest request;

        public GetProgressTask(GetProgressRequest request, AsyncAction<AsyncResult<GetProgressResult>> userCallback) {
            super((Gs2RestSession)Gs2EnhanceRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetProgressResult parse(JsonNode data) {
            return GetProgressResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "enhance").replace("{region}", Gs2EnhanceRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/progress";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class CreateProgressByUserIdTask
    extends Gs2RestSessionTask<CreateProgressByUserIdResult> {
        private CreateProgressByUserIdRequest request;

        public CreateProgressByUserIdTask(CreateProgressByUserIdRequest request, AsyncAction<AsyncResult<CreateProgressByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2EnhanceRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateProgressByUserIdResult parse(JsonNode data) {
            return CreateProgressByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "enhance").replace("{region}", Gs2EnhanceRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/progress";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("rateName", CreateProgressByUserIdTask.this.request.getRateName());
                    this.put("targetItemSetId", CreateProgressByUserIdTask.this.request.getTargetItemSetId());
                    this.put("materials", CreateProgressByUserIdTask.this.request.getMaterials() == null ? new ArrayList() : CreateProgressByUserIdTask.this.request.getMaterials().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("force", CreateProgressByUserIdTask.this.request.getForce());
                    this.put("contextStack", CreateProgressByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeProgressesByUserIdTask
    extends Gs2RestSessionTask<DescribeProgressesByUserIdResult> {
        private DescribeProgressesByUserIdRequest request;

        public DescribeProgressesByUserIdTask(DescribeProgressesByUserIdRequest request, AsyncAction<AsyncResult<DescribeProgressesByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2EnhanceRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeProgressesByUserIdResult parse(JsonNode data) {
            return DescribeProgressesByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "enhance").replace("{region}", Gs2EnhanceRestClient.this.session.getRegion().getName()) + "/{namespaceName}/progress";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getUserId() != null) {
                queryStrings.add("userId=" + EncodingUtil.urlEncode(String.valueOf(this.request.getUserId())));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DirectEnhanceByStampSheetTask
    extends Gs2RestSessionTask<DirectEnhanceByStampSheetResult> {
        private DirectEnhanceByStampSheetRequest request;

        public DirectEnhanceByStampSheetTask(DirectEnhanceByStampSheetRequest request, AsyncAction<AsyncResult<DirectEnhanceByStampSheetResult>> userCallback) {
            super((Gs2RestSession)Gs2EnhanceRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DirectEnhanceByStampSheetResult parse(JsonNode data) {
            return DirectEnhanceByStampSheetResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "enhance").replace("{region}", Gs2EnhanceRestClient.this.session.getRegion().getName()) + "/stamp/enhance/direct";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampSheet", DirectEnhanceByStampSheetTask.this.request.getStampSheet());
                    this.put("keyId", DirectEnhanceByStampSheetTask.this.request.getKeyId());
                    this.put("contextStack", DirectEnhanceByStampSheetTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DirectEnhanceByUserIdTask
    extends Gs2RestSessionTask<DirectEnhanceByUserIdResult> {
        private DirectEnhanceByUserIdRequest request;

        public DirectEnhanceByUserIdTask(DirectEnhanceByUserIdRequest request, AsyncAction<AsyncResult<DirectEnhanceByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2EnhanceRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DirectEnhanceByUserIdResult parse(JsonNode data) {
            return DirectEnhanceByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "enhance").replace("{region}", Gs2EnhanceRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/enhance/{rateName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{rateName}", this.request.getRateName() == null || this.request.getRateName().length() == 0 ? "null" : String.valueOf(this.request.getRateName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("targetItemSetId", DirectEnhanceByUserIdTask.this.request.getTargetItemSetId());
                    this.put("materials", DirectEnhanceByUserIdTask.this.request.getMaterials() == null ? new ArrayList() : DirectEnhanceByUserIdTask.this.request.getMaterials().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("config", DirectEnhanceByUserIdTask.this.request.getConfig() == null ? new ArrayList() : DirectEnhanceByUserIdTask.this.request.getConfig().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", DirectEnhanceByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DirectEnhanceTask
    extends Gs2RestSessionTask<DirectEnhanceResult> {
        private DirectEnhanceRequest request;

        public DirectEnhanceTask(DirectEnhanceRequest request, AsyncAction<AsyncResult<DirectEnhanceResult>> userCallback) {
            super((Gs2RestSession)Gs2EnhanceRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DirectEnhanceResult parse(JsonNode data) {
            return DirectEnhanceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "enhance").replace("{region}", Gs2EnhanceRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/enhance/{rateName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{rateName}", this.request.getRateName() == null || this.request.getRateName().length() == 0 ? "null" : String.valueOf(this.request.getRateName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("targetItemSetId", DirectEnhanceTask.this.request.getTargetItemSetId());
                    this.put("materials", DirectEnhanceTask.this.request.getMaterials() == null ? new ArrayList() : DirectEnhanceTask.this.request.getMaterials().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("config", DirectEnhanceTask.this.request.getConfig() == null ? new ArrayList() : DirectEnhanceTask.this.request.getConfig().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", DirectEnhanceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class DeleteRateModelMasterTask
    extends Gs2RestSessionTask<DeleteRateModelMasterResult> {
        private DeleteRateModelMasterRequest request;

        public DeleteRateModelMasterTask(DeleteRateModelMasterRequest request, AsyncAction<AsyncResult<DeleteRateModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2EnhanceRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteRateModelMasterResult parse(JsonNode data) {
            return DeleteRateModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "enhance").replace("{region}", Gs2EnhanceRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/model/{rateName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{rateName}", this.request.getRateName() == null || this.request.getRateName().length() == 0 ? "null" : String.valueOf(this.request.getRateName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateRateModelMasterTask
    extends Gs2RestSessionTask<UpdateRateModelMasterResult> {
        private UpdateRateModelMasterRequest request;

        public UpdateRateModelMasterTask(UpdateRateModelMasterRequest request, AsyncAction<AsyncResult<UpdateRateModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2EnhanceRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateRateModelMasterResult parse(JsonNode data) {
            return UpdateRateModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "enhance").replace("{region}", Gs2EnhanceRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/model/{rateName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{rateName}", this.request.getRateName() == null || this.request.getRateName().length() == 0 ? "null" : String.valueOf(this.request.getRateName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateRateModelMasterTask.this.request.getDescription());
                    this.put("metadata", UpdateRateModelMasterTask.this.request.getMetadata());
                    this.put("targetInventoryModelId", UpdateRateModelMasterTask.this.request.getTargetInventoryModelId());
                    this.put("acquireExperienceSuffix", UpdateRateModelMasterTask.this.request.getAcquireExperienceSuffix());
                    this.put("materialInventoryModelId", UpdateRateModelMasterTask.this.request.getMaterialInventoryModelId());
                    this.put("acquireExperienceHierarchy", UpdateRateModelMasterTask.this.request.getAcquireExperienceHierarchy() == null ? new ArrayList() : UpdateRateModelMasterTask.this.request.getAcquireExperienceHierarchy().stream().map(item -> item).collect(Collectors.toList()));
                    this.put("experienceModelId", UpdateRateModelMasterTask.this.request.getExperienceModelId());
                    this.put("bonusRates", UpdateRateModelMasterTask.this.request.getBonusRates() == null ? new ArrayList() : UpdateRateModelMasterTask.this.request.getBonusRates().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", UpdateRateModelMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetRateModelMasterTask
    extends Gs2RestSessionTask<GetRateModelMasterResult> {
        private GetRateModelMasterRequest request;

        public GetRateModelMasterTask(GetRateModelMasterRequest request, AsyncAction<AsyncResult<GetRateModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2EnhanceRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetRateModelMasterResult parse(JsonNode data) {
            return GetRateModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "enhance").replace("{region}", Gs2EnhanceRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/model/{rateName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{rateName}", this.request.getRateName() == null || this.request.getRateName().length() == 0 ? "null" : String.valueOf(this.request.getRateName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateRateModelMasterTask
    extends Gs2RestSessionTask<CreateRateModelMasterResult> {
        private CreateRateModelMasterRequest request;

        public CreateRateModelMasterTask(CreateRateModelMasterRequest request, AsyncAction<AsyncResult<CreateRateModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2EnhanceRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateRateModelMasterResult parse(JsonNode data) {
            return CreateRateModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "enhance").replace("{region}", Gs2EnhanceRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/model";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateRateModelMasterTask.this.request.getName());
                    this.put("description", CreateRateModelMasterTask.this.request.getDescription());
                    this.put("metadata", CreateRateModelMasterTask.this.request.getMetadata());
                    this.put("targetInventoryModelId", CreateRateModelMasterTask.this.request.getTargetInventoryModelId());
                    this.put("acquireExperienceSuffix", CreateRateModelMasterTask.this.request.getAcquireExperienceSuffix());
                    this.put("materialInventoryModelId", CreateRateModelMasterTask.this.request.getMaterialInventoryModelId());
                    this.put("acquireExperienceHierarchy", CreateRateModelMasterTask.this.request.getAcquireExperienceHierarchy() == null ? new ArrayList() : CreateRateModelMasterTask.this.request.getAcquireExperienceHierarchy().stream().map(item -> item).collect(Collectors.toList()));
                    this.put("experienceModelId", CreateRateModelMasterTask.this.request.getExperienceModelId());
                    this.put("bonusRates", CreateRateModelMasterTask.this.request.getBonusRates() == null ? new ArrayList() : CreateRateModelMasterTask.this.request.getBonusRates().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", CreateRateModelMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeRateModelMastersTask
    extends Gs2RestSessionTask<DescribeRateModelMastersResult> {
        private DescribeRateModelMastersRequest request;

        public DescribeRateModelMastersTask(DescribeRateModelMastersRequest request, AsyncAction<AsyncResult<DescribeRateModelMastersResult>> userCallback) {
            super((Gs2RestSession)Gs2EnhanceRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeRateModelMastersResult parse(JsonNode data) {
            return DescribeRateModelMastersResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "enhance").replace("{region}", Gs2EnhanceRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/model";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetRateModelTask
    extends Gs2RestSessionTask<GetRateModelResult> {
        private GetRateModelRequest request;

        public GetRateModelTask(GetRateModelRequest request, AsyncAction<AsyncResult<GetRateModelResult>> userCallback) {
            super((Gs2RestSession)Gs2EnhanceRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetRateModelResult parse(JsonNode data) {
            return GetRateModelResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "enhance").replace("{region}", Gs2EnhanceRestClient.this.session.getRegion().getName()) + "/{namespaceName}/model/{rateName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{rateName}", this.request.getRateName() == null || this.request.getRateName().length() == 0 ? "null" : String.valueOf(this.request.getRateName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeRateModelsTask
    extends Gs2RestSessionTask<DescribeRateModelsResult> {
        private DescribeRateModelsRequest request;

        public DescribeRateModelsTask(DescribeRateModelsRequest request, AsyncAction<AsyncResult<DescribeRateModelsResult>> userCallback) {
            super((Gs2RestSession)Gs2EnhanceRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeRateModelsResult parse(JsonNode data) {
            return DescribeRateModelsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "enhance").replace("{region}", Gs2EnhanceRestClient.this.session.getRegion().getName()) + "/{namespaceName}/model";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteNamespaceTask
    extends Gs2RestSessionTask<DeleteNamespaceResult> {
        private DeleteNamespaceRequest request;

        public DeleteNamespaceTask(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2EnhanceRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteNamespaceResult parse(JsonNode data) {
            return DeleteNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "enhance").replace("{region}", Gs2EnhanceRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateNamespaceTask
    extends Gs2RestSessionTask<UpdateNamespaceResult> {
        private UpdateNamespaceRequest request;

        public UpdateNamespaceTask(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2EnhanceRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateNamespaceResult parse(JsonNode data) {
            return UpdateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "enhance").replace("{region}", Gs2EnhanceRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateNamespaceTask.this.request.getDescription());
                    this.put("enableDirectEnhance", UpdateNamespaceTask.this.request.getEnableDirectEnhance());
                    this.put("queueNamespaceId", UpdateNamespaceTask.this.request.getQueueNamespaceId());
                    this.put("keyId", UpdateNamespaceTask.this.request.getKeyId());
                    this.put("enhanceScript", UpdateNamespaceTask.this.request.getEnhanceScript() != null ? UpdateNamespaceTask.this.request.getEnhanceScript().toJson() : null);
                    this.put("logSetting", UpdateNamespaceTask.this.request.getLogSetting() != null ? UpdateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", UpdateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceTask
    extends Gs2RestSessionTask<GetNamespaceResult> {
        private GetNamespaceRequest request;

        public GetNamespaceTask(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2EnhanceRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceResult parse(JsonNode data) {
            return GetNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "enhance").replace("{region}", Gs2EnhanceRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceStatusTask
    extends Gs2RestSessionTask<GetNamespaceStatusResult> {
        private GetNamespaceStatusRequest request;

        public GetNamespaceStatusTask(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> userCallback) {
            super((Gs2RestSession)Gs2EnhanceRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceStatusResult parse(JsonNode data) {
            return GetNamespaceStatusResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "enhance").replace("{region}", Gs2EnhanceRestClient.this.session.getRegion().getName()) + "/{namespaceName}/status";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateNamespaceTask
    extends Gs2RestSessionTask<CreateNamespaceResult> {
        private CreateNamespaceRequest request;

        public CreateNamespaceTask(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2EnhanceRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateNamespaceResult parse(JsonNode data) {
            return CreateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "enhance").replace("{region}", Gs2EnhanceRestClient.this.session.getRegion().getName()) + "/";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateNamespaceTask.this.request.getName());
                    this.put("description", CreateNamespaceTask.this.request.getDescription());
                    this.put("enableDirectEnhance", CreateNamespaceTask.this.request.getEnableDirectEnhance());
                    this.put("queueNamespaceId", CreateNamespaceTask.this.request.getQueueNamespaceId());
                    this.put("keyId", CreateNamespaceTask.this.request.getKeyId());
                    this.put("enhanceScript", CreateNamespaceTask.this.request.getEnhanceScript() != null ? CreateNamespaceTask.this.request.getEnhanceScript().toJson() : null);
                    this.put("logSetting", CreateNamespaceTask.this.request.getLogSetting() != null ? CreateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", CreateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeNamespacesTask
    extends Gs2RestSessionTask<DescribeNamespacesResult> {
        private DescribeNamespacesRequest request;

        public DescribeNamespacesTask(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> userCallback) {
            super((Gs2RestSession)Gs2EnhanceRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeNamespacesResult parse(JsonNode data) {
            return DescribeNamespacesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "enhance").replace("{region}", Gs2EnhanceRestClient.this.session.getRegion().getName()) + "/";
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }
}

