/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.distributor.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.distributor.Gs2DistributorRestClient;
import io.gs2.distributor.domain.model.NamespaceDomain;
import java.util.List;

public class DistributeDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2DistributorRestClient client;
    private final String namespaceName;
    private final String parentKey;
    String inboxNamespaceId;
    String result;
    String contextStack;
    List<String> taskResults;
    String sheetResult;

    public String getInboxNamespaceId() {
        return this.inboxNamespaceId;
    }

    public String getResult() {
        return this.result;
    }

    public String getContextStack() {
        return this.contextStack;
    }

    public List<String> getTaskResults() {
        return this.taskResults;
    }

    public String getSheetResult() {
        return this.sheetResult;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public DistributeDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2DistributorRestClient(session);
        this.namespaceName = namespaceName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "Distribute");
    }

    public static String createCacheParentKey(String namespaceName, String childType) {
        return String.join((CharSequence)":", "distributor", namespaceName, childType);
    }

    public static String createCacheKey() {
        return "Singleton";
    }
}

