/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.distributor.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.distributor.Gs2DistributorRestClient;
import io.gs2.distributor.domain.model.DistributorModelDomain;
import io.gs2.distributor.domain.model.NamespaceDomain;
import io.gs2.distributor.model.DistributorModel;
import io.gs2.distributor.request.DescribeDistributorModelsRequest;
import io.gs2.distributor.result.DescribeDistributorModelsResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeDistributorModelsIterator
implements Iterator<DistributorModel>,
Iterable<DistributorModel> {
    CacheDatabase cache;
    Gs2DistributorRestClient client;
    String namespaceName;
    boolean last;
    List<DistributorModel> result;
    Integer fetchSize;

    public DescribeDistributorModelsIterator(CacheDatabase cache, Gs2DistributorRestClient client, String namespaceName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.last = false;
        this.result = new ArrayList<DistributorModel>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "DistributorModel");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, DistributorModel.class)) {
            this.result = this.cache.list(parentKey, DistributorModel.class).stream().collect(Collectors.toList());
            this.last = true;
        } else {
            DescribeDistributorModelsResult r = this.client.describeDistributorModels(new DescribeDistributorModelsRequest().withNamespaceName(this.namespaceName));
            this.result = r.getItems();
            this.last = true;
            for (DistributorModel item : this.result) {
                this.cache.put(parentKey, DistributorModelDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, DistributorModel.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public DistributorModel next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        DistributorModel ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<DistributorModel> iterator() {
        return this;
    }
}

