/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.dictionary.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.dictionary.Gs2DictionaryRestClient;
import io.gs2.dictionary.domain.model.NamespaceDomain;
import io.gs2.dictionary.model.EntryModel;
import io.gs2.dictionary.request.GetEntryModelRequest;
import io.gs2.dictionary.result.GetEntryModelResult;

public class EntryModelDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2DictionaryRestClient client;
    private final String namespaceName;
    private final String entryName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public EntryModelDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String entryName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2DictionaryRestClient(session);
        this.namespaceName = namespaceName;
        this.entryName = entryName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "EntryModel");
    }

    private EntryModel get(GetEntryModelRequest request) {
        request.withNamespaceName(this.namespaceName).withEntryName(this.entryName);
        GetEntryModelResult result = this.client.getEntryModel(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, EntryModelDomain.createCacheKey(request.getEntryName() != null ? request.getEntryName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public static String createCacheParentKey(String namespaceName, String entryName, String childType) {
        return String.join((CharSequence)":", "dictionary", namespaceName, entryName, childType);
    }

    public static String createCacheKey(String entryName) {
        return String.join((CharSequence)":", entryName);
    }

    public EntryModel model() {
        EntryModel value = this.cache.get(this.parentKey, EntryModelDomain.createCacheKey(this.getEntryName() != null ? this.getEntryName().toString() : null), EntryModel.class);
        if (value == null) {
            try {
                this.get(new GetEntryModelRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, EntryModelDomain.createCacheKey(this.getEntryName() != null ? this.getEntryName().toString() : null), EntryModel.class);
            }
            value = this.cache.get(this.parentKey, EntryModelDomain.createCacheKey(this.getEntryName() != null ? this.getEntryName().toString() : null), EntryModel.class);
        }
        return value;
    }
}

