/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.dictionary.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.dictionary.Gs2DictionaryRestClient;
import io.gs2.dictionary.domain.model.NamespaceDomain;
import io.gs2.dictionary.model.CurrentEntryMaster;
import io.gs2.dictionary.request.ExportMasterRequest;
import io.gs2.dictionary.request.GetCurrentEntryMasterRequest;
import io.gs2.dictionary.request.UpdateCurrentEntryMasterFromGitHubRequest;
import io.gs2.dictionary.request.UpdateCurrentEntryMasterRequest;
import io.gs2.dictionary.result.ExportMasterResult;
import io.gs2.dictionary.result.GetCurrentEntryMasterResult;
import io.gs2.dictionary.result.UpdateCurrentEntryMasterFromGitHubResult;
import io.gs2.dictionary.result.UpdateCurrentEntryMasterResult;

public class CurrentEntryMasterDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2DictionaryRestClient client;
    private final String namespaceName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public CurrentEntryMasterDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2DictionaryRestClient(session);
        this.namespaceName = namespaceName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "CurrentEntryMaster");
    }

    public CurrentEntryMasterDomain exportMaster(ExportMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        ExportMasterResult result = this.client.exportMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentEntryMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentEntryMasterDomain domain = this;
        return domain;
    }

    private CurrentEntryMaster get(GetCurrentEntryMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        GetCurrentEntryMasterResult result = this.client.getCurrentEntryMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentEntryMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public CurrentEntryMasterDomain update(UpdateCurrentEntryMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        UpdateCurrentEntryMasterResult result = this.client.updateCurrentEntryMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentEntryMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentEntryMasterDomain domain = this;
        return domain;
    }

    public CurrentEntryMasterDomain updateFromGitHub(UpdateCurrentEntryMasterFromGitHubRequest request) {
        request.withNamespaceName(this.namespaceName);
        UpdateCurrentEntryMasterFromGitHubResult result = this.client.updateCurrentEntryMasterFromGitHub(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentEntryMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentEntryMasterDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String childType) {
        return String.join((CharSequence)":", "dictionary", namespaceName, childType);
    }

    public static String createCacheKey(String namespaceName) {
        return String.join((CharSequence)":", namespaceName);
    }

    public CurrentEntryMaster model() {
        CurrentEntryMaster value = this.cache.get(this.parentKey, CurrentEntryMasterDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), CurrentEntryMaster.class);
        if (value == null) {
            try {
                this.get(new GetCurrentEntryMasterRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, CurrentEntryMasterDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), CurrentEntryMaster.class);
            }
            value = this.cache.get(this.parentKey, CurrentEntryMasterDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), CurrentEntryMaster.class);
        }
        return value;
    }
}

