/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.dictionary.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.dictionary.Gs2DictionaryRestClient;
import io.gs2.dictionary.domain.model.EntryModelDomain;
import io.gs2.dictionary.domain.model.NamespaceDomain;
import io.gs2.dictionary.model.EntryModel;
import io.gs2.dictionary.request.DescribeEntryModelsRequest;
import io.gs2.dictionary.result.DescribeEntryModelsResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeEntryModelsIterator
implements Iterator<EntryModel>,
Iterable<EntryModel> {
    CacheDatabase cache;
    Gs2DictionaryRestClient client;
    String namespaceName;
    boolean last;
    List<EntryModel> result;
    Integer fetchSize;

    public DescribeEntryModelsIterator(CacheDatabase cache, Gs2DictionaryRestClient client, String namespaceName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.last = false;
        this.result = new ArrayList<EntryModel>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "EntryModel");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, EntryModel.class)) {
            this.result = this.cache.list(parentKey, EntryModel.class).stream().collect(Collectors.toList());
            this.last = true;
        } else {
            DescribeEntryModelsResult r = this.client.describeEntryModels(new DescribeEntryModelsRequest().withNamespaceName(this.namespaceName));
            this.result = r.getItems();
            this.last = true;
            for (EntryModel item : this.result) {
                this.cache.put(parentKey, EntryModelDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, EntryModel.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public EntryModel next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        EntryModel ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<EntryModel> iterator() {
        return this;
    }
}

