/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.dictionary.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.dictionary.Gs2DictionaryRestClient;
import io.gs2.dictionary.domain.model.EntryModelMasterDomain;
import io.gs2.dictionary.domain.model.NamespaceDomain;
import io.gs2.dictionary.model.EntryModelMaster;
import io.gs2.dictionary.request.DescribeEntryModelMastersRequest;
import io.gs2.dictionary.result.DescribeEntryModelMastersResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeEntryModelMastersIterator
implements Iterator<EntryModelMaster>,
Iterable<EntryModelMaster> {
    CacheDatabase cache;
    Gs2DictionaryRestClient client;
    String namespaceName;
    String pageToken;
    boolean last;
    List<EntryModelMaster> result;
    Integer fetchSize;

    public DescribeEntryModelMastersIterator(CacheDatabase cache, Gs2DictionaryRestClient client, String namespaceName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<EntryModelMaster>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "EntryModelMaster");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, EntryModelMaster.class)) {
            this.result = this.cache.list(parentKey, EntryModelMaster.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeEntryModelMastersResult r = this.client.describeEntryModelMasters(new DescribeEntryModelMastersRequest().withNamespaceName(this.namespaceName).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (EntryModelMaster item : this.result) {
                this.cache.put(parentKey, EntryModelMasterDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, EntryModelMaster.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public EntryModelMaster next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        EntryModelMaster ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<EntryModelMaster> iterator() {
        return this;
    }
}

