/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.dictionary.domain.iterator;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.dictionary.Gs2DictionaryRestClient;
import io.gs2.dictionary.domain.model.EntryDomain;
import io.gs2.dictionary.domain.model.UserDomain;
import io.gs2.dictionary.model.Entry;
import io.gs2.dictionary.request.DescribeEntriesRequest;
import io.gs2.dictionary.result.DescribeEntriesResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeEntriesIterator
implements Iterator<Entry>,
Iterable<Entry> {
    CacheDatabase cache;
    Gs2DictionaryRestClient client;
    String namespaceName;
    AccessToken accessToken;
    String pageToken;
    boolean last;
    List<Entry> result;
    Integer fetchSize;

    public DescribeEntriesIterator(CacheDatabase cache, Gs2DictionaryRestClient client, String namespaceName, AccessToken accessToken) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<Entry>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "Entry");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, Entry.class)) {
            this.result = this.cache.list(parentKey, Entry.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeEntriesResult r = this.client.describeEntries(new DescribeEntriesRequest().withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (Entry item : this.result) {
                this.cache.put(parentKey, EntryDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, Entry.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public Entry next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        Entry ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<Entry> iterator() {
        return this;
    }
}

