/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.datastore.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.datastore.Gs2DatastoreRestClient;
import io.gs2.datastore.domain.iterator.DescribeDataObjectsByUserIdIterator;
import io.gs2.datastore.domain.model.DataObjectDomain;
import io.gs2.datastore.domain.model.NamespaceDomain;
import io.gs2.datastore.request.PrepareDownloadByGenerationAndUserIdRequest;
import io.gs2.datastore.request.PrepareDownloadByUserIdRequest;
import io.gs2.datastore.request.PrepareUploadByUserIdRequest;
import io.gs2.datastore.result.PrepareDownloadByGenerationAndUserIdResult;
import io.gs2.datastore.result.PrepareDownloadByUserIdResult;
import io.gs2.datastore.result.PrepareUploadByUserIdResult;

public class UserDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2DatastoreRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String parentKey;
    String uploadUrl;
    String fileUrl;
    Long contentLength;
    String nextPageToken;

    public String getUploadUrl() {
        return this.uploadUrl;
    }

    public String getFileUrl() {
        return this.fileUrl;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public UserDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2DatastoreRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "User");
    }

    public DataObjectDomain prepareUpload(PrepareUploadByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId);
        PrepareUploadByUserIdResult result = this.client.prepareUploadByUserId(request);
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "DataObject");
        if (result.getItem() != null) {
            this.cache.put(parentKey, DataObjectDomain.createCacheKey(result.getItem().getName() != null ? result.getItem().getName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        DataObjectDomain domain = new DataObjectDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), result.getItem().getUserId(), result.getItem().getName());
        domain.uploadUrl = result.getUploadUrl();
        return domain;
    }

    public DataObjectDomain prepareDownload(PrepareDownloadByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId);
        PrepareDownloadByUserIdResult result = this.client.prepareDownloadByUserId(request);
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "DataObject");
        if (result.getItem() != null) {
            this.cache.put(parentKey, DataObjectDomain.createCacheKey(result.getItem().getName() != null ? result.getItem().getName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        DataObjectDomain domain = new DataObjectDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), result.getItem().getUserId(), result.getItem().getName());
        domain.fileUrl = result.getFileUrl();
        domain.contentLength = result.getContentLength();
        return domain;
    }

    public DataObjectDomain prepareDownloadByGeneration(PrepareDownloadByGenerationAndUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId);
        PrepareDownloadByGenerationAndUserIdResult result = this.client.prepareDownloadByGenerationAndUserId(request);
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "DataObject");
        if (result.getItem() != null) {
            this.cache.put(parentKey, DataObjectDomain.createCacheKey(result.getItem().getName() != null ? result.getItem().getName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        DataObjectDomain domain = new DataObjectDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), result.getItem().getUserId(), result.getItem().getName());
        domain.fileUrl = result.getFileUrl();
        domain.contentLength = result.getContentLength();
        return domain;
    }

    public DescribeDataObjectsByUserIdIterator dataObjects(String status) {
        return new DescribeDataObjectsByUserIdIterator(this.cache, this.client, this.namespaceName, this.userId, status);
    }

    public DataObjectDomain dataObject(String dataObjectName) {
        return new DataObjectDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.userId, dataObjectName);
    }

    public static String createCacheParentKey(String namespaceName, String userId, String childType) {
        return String.join((CharSequence)":", "datastore", namespaceName, userId, childType);
    }

    public static String createCacheKey(String userId) {
        return String.join((CharSequence)":", userId);
    }
}

